/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.content.Context;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.models.Size;
import com.inlocomedia.android.core.util.ScreenHelper;
import org.json.JSONException;
import org.json.JSONObject;

public enum AdType {
    CUSTOM("custom", -1, -1),
    NATIVE_LARGE("native_large_list", -1, -1),
    NATIVE_SMALL("native_small_list", -1, -1),
    NATIVE_OFFER("native_offer_list", -1, -1),
    DISPLAY_BANNER_SMALL("display_small", 320, 50),
    DISPLAY_BANNER_SMALL_LANDSCAPE("display_small_landscape", 480, 32),
    DISPLAY_BANNER_FULL_IAB("display_full_iab", 468, 60),
    DISPLAY_BANNER_LARGE("display_large", 320, 100),
    DISPLAY_BANNER_TABLET("display_tablet", 728, 90),
    DISPLAY_BANNER_MEDIUM_RECTANGLE("display_medium_rectangle_iab", 300, 250),
    DISPLAY_FULLSCREEN("display_full_screen", 320, 480),
    DISPLAY_FULLSCREEN_LANDSCAPE("display_full_screen_landscape", 480, 320),
    DISPLAY_FULLSCREEN_TABLET("display_full_screen_tablet", 768, 1024),
    DISPLAY_FULLSCREEN_TABLET_LANDSCAPE("display_full_screen_landscape_tablet", 1024, 768),
    DISPLAY_TILE("display_tile", 240, 240),
    SMART_BANNER("smart_banner", -1, -2),
    NOTIFICATION("notification_small", -1, -1);

    private static final float SMART_BANNER_HEIGHT_THRESHOLD = 0.15f;
    private String value;
    private int width;
    private int height;

    private AdType(String value, int width, int height) {
        this.value = value;
        this.width = width;
        this.height = height;
    }

    public int getWidthPx(Context context) {
        return (int)((float)this.width * ScreenHelper.getDensity((Context)context));
    }

    public int getHeightPx(Context context) {
        return (int)((float)this.height * ScreenHelper.getDensity((Context)context));
    }

    public int getWidthDp() {
        return this.width;
    }

    public int getHeightDp() {
        return this.height;
    }

    public static AdType getBySize(int width, int height) {
        for (AdType adType : AdType.values()) {
            if (!adType.equals(width, height)) continue;
            return adType;
        }
        return null;
    }

    public static AdType getByValue(String value) {
        for (AdType adType : AdType.values()) {
            if (!adType.equals(value)) continue;
            return adType;
        }
        return null;
    }

    public static AdType fromJSON(JSONObject json) throws InvalidMappingException {
        String string2 = json.optString("type");
        return string2 != null ? AdType.getByValue(string2) : null;
    }

    public JSONObject parseToJSON(JSONObject json) throws InvalidMappingException {
        if (json == null) {
            json = new JSONObject();
        }
        try {
            json.put("type", (Object)this.getValue());
        }
        catch (JSONException jSONException) {
            InvalidMappingException invalidMappingException = new InvalidMappingException("Invalid json mapping for advertisement type");
            invalidMappingException.setStackTrace(jSONException.getStackTrace());
            throw invalidMappingException;
        }
        return json;
    }

    public String getValue() {
        return this.value;
    }

    public AdType getFunctionalAdType(Context context) {
        if (this != SMART_BANNER) {
            return this;
        }
        Size size = ScreenHelper.getScreenSizeInDp((Context)context);
        if (AdType.isBannerFitToScreen(size, DISPLAY_BANNER_TABLET)) {
            return DISPLAY_BANNER_TABLET;
        }
        if (AdType.isBannerFitToScreen(size, DISPLAY_BANNER_FULL_IAB)) {
            return DISPLAY_BANNER_FULL_IAB;
        }
        if (AdType.isBannerFitToScreen(size, DISPLAY_BANNER_SMALL_LANDSCAPE)) {
            return DISPLAY_BANNER_SMALL_LANDSCAPE;
        }
        return DISPLAY_BANNER_SMALL;
    }

    private static boolean isBannerFitToScreen(Size screenSizeDp, AdType adType) {
        return (float)adType.getWidthDp() <= screenSizeDp.getWidth() && adType.getHeightDp() < Math.round(0.15f * screenSizeDp.getHeight());
    }

    public static AdType getFullscreenType(Context context, int screenOrientation) {
        AdType adType = screenOrientation == 1 ? (AdType.isFullScreenAdFitToDisplay(context, DISPLAY_FULLSCREEN_TABLET) ? DISPLAY_FULLSCREEN_TABLET : DISPLAY_FULLSCREEN) : (AdType.isFullScreenAdFitToDisplay(context, DISPLAY_FULLSCREEN_TABLET_LANDSCAPE) ? DISPLAY_FULLSCREEN_TABLET_LANDSCAPE : DISPLAY_FULLSCREEN_LANDSCAPE);
        return adType;
    }

    private static boolean isFullScreenAdFitToDisplay(Context context, AdType adType) {
        Size size = ScreenHelper.getScreenSizeInPx((Context)context);
        return (float)adType.getWidthPx(context) <= size.getWidth() && (float)adType.getHeightPx(context) <= size.getHeight();
    }

    public boolean isDisplay() {
        switch (this) {
            case DISPLAY_TILE: 
            case DISPLAY_BANNER_FULL_IAB: 
            case DISPLAY_BANNER_SMALL: 
            case DISPLAY_BANNER_SMALL_LANDSCAPE: 
            case DISPLAY_BANNER_LARGE: 
            case DISPLAY_BANNER_MEDIUM_RECTANGLE: 
            case DISPLAY_BANNER_TABLET: 
            case DISPLAY_FULLSCREEN: 
            case DISPLAY_FULLSCREEN_LANDSCAPE: 
            case DISPLAY_FULLSCREEN_TABLET: 
            case DISPLAY_FULLSCREEN_TABLET_LANDSCAPE: 
            case SMART_BANNER: {
                return true;
            }
        }
        return false;
    }

    public boolean isNative() {
        switch (this) {
            case NATIVE_OFFER: 
            case NATIVE_LARGE: 
            case NATIVE_SMALL: {
                return true;
            }
        }
        return false;
    }

    public boolean isFullScreen() {
        switch (this) {
            case DISPLAY_FULLSCREEN: 
            case DISPLAY_FULLSCREEN_LANDSCAPE: 
            case DISPLAY_FULLSCREEN_TABLET: 
            case DISPLAY_FULLSCREEN_TABLET_LANDSCAPE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNotification() {
        switch (this) {
            case NOTIFICATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isCustom() {
        switch (this) {
            case CUSTOM: {
                return true;
            }
        }
        return false;
    }

    private boolean equals(int width, int height) {
        return this.getWidthDp() == width && this.getHeightDp() == height;
    }

    private boolean equals(String value) {
        return this.getValue().equals(value);
    }

    public String toString() {
        return this.value + "_" + this.getWidthDp() + "x" + this.getHeightDp();
    }

    public static AdType getByAttr(int attr2) {
        switch (attr2) {
            case 100: {
                return NATIVE_SMALL;
            }
            case 101: {
                return NATIVE_LARGE;
            }
            case 102: {
                return NATIVE_OFFER;
            }
            case 0: {
                return SMART_BANNER;
            }
            case 200: {
                return DISPLAY_BANNER_SMALL;
            }
            case 202: {
                return DISPLAY_BANNER_LARGE;
            }
            case 204: {
                return DISPLAY_BANNER_MEDIUM_RECTANGLE;
            }
            case 201: {
                return DISPLAY_BANNER_SMALL_LANDSCAPE;
            }
            case 203: {
                return DISPLAY_BANNER_FULL_IAB;
            }
            case 300: {
                return DISPLAY_FULLSCREEN;
            }
            case 301: {
                return DISPLAY_FULLSCREEN_LANDSCAPE;
            }
            case 205: {
                return DISPLAY_BANNER_TABLET;
            }
            case 302: {
                return DISPLAY_FULLSCREEN_TABLET;
            }
            case 303: {
                return DISPLAY_FULLSCREEN_TABLET_LANDSCAPE;
            }
            case 206: {
                return DISPLAY_TILE;
            }
            case 401: {
                return CUSTOM;
            }
        }
        return null;
    }
}

