/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.content.Context;
import android.database.DataSetObserver;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.AdViewListener;
import java.util.ArrayList;
import java.util.List;

public class AdvertisementAdapter
extends BaseAdapter {
    private static final int TYPE_AD = 853125;
    private final BaseAdapter mAdapter;
    private final LayoutInflater mInflater;
    private final SparseArray<AdView> mAdViewsHolder;
    private final int mAdViewLayoutId;
    private int mAdLoadedCount;
    private List<Integer> mAdPositions;
    private final int mAdsInterval;
    private int mListSize;
    private AdViewListener mAdViewListener;

    public AdvertisementAdapter(Context context, BaseAdapter adapter, int adLayoutId, int adsInterval) {
        this.mAdapter = adapter;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mAdViewLayoutId = adLayoutId;
        this.mAdsInterval = adsInterval;
        this.mAdPositions = new ArrayList<Integer>();
        this.mAdViewsHolder = new SparseArray();
        this.mAdViewListener = new AdViewListener(){

            @Override
            public void onAdError(AdView adView, AdError adError) {
            }

            @Override
            public void onAdViewReady(AdView adView) {
                if (AdvertisementAdapter.this.mAdViewsHolder.indexOfValue((Object)adView) < 0) {
                    AdvertisementAdapter.this.mAdLoadedCount++;
                }
                AdvertisementAdapter.this.notifyDataSetChanged();
            }
        };
        this.reload();
    }

    private void reload() {
        List<Integer> list = this.generateAdPositions(this.mAdsInterval);
        this.recreateViewHash(list, this.mAdPositions);
        this.mListSize = this.mAdapter.getCount();
        this.mAdPositions = list;
    }

    private void recreateViewHash(List<Integer> newAdPositions, List<Integer> oldAdPositions) {
        int n2;
        int n3 = oldAdPositions.size();
        for (int i2 = n2 = Math.max(0, newAdPositions.size() - 1); i2 < n3; ++i2) {
            AdView adView = (AdView)((Object)this.mAdViewsHolder.get(i2));
            if (adView == null) continue;
            this.mAdViewsHolder.remove(i2);
            if (!adView.isLoaded()) continue;
            --this.mAdLoadedCount;
        }
    }

    private List<Integer> generateAdPositions(int module) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.mAdapter.getCount();
        for (int i2 = 0; i2 < n2; i2 += module) {
            arrayList.add(module + i2 + arrayList.size());
        }
        return arrayList;
    }

    private boolean isAdRegisteredPosition(int position) {
        for (int n2 : this.mAdPositions) {
            if (n2 != position) continue;
            return true;
        }
        return false;
    }

    private boolean isAdType(int position) {
        AdView adView = (AdView)((Object)this.mAdViewsHolder.get(position));
        return adView != null && adView.isLoaded();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int n2 = this.getItemViewType(position);
        switch (n2) {
            case 853125: {
                convertView = (View)this.mAdViewsHolder.get(position);
                break;
            }
            default: {
                convertView = convertView == null || convertView instanceof AdView ? this.mAdapter.getView(this.getPosition(position), null, parent) : this.mAdapter.getView(this.getPosition(position), convertView, parent);
                if (!this.isAdRegisteredPosition(position)) break;
                AdView adView = (AdView)((Object)this.mAdViewsHolder.get(position));
                if (adView == null) {
                    adView = (AdView)this.mInflater.inflate(this.mAdViewLayoutId, null);
                    this.mAdViewsHolder.put(position, (Object)adView);
                }
                if (adView.isLoading()) break;
                adView.setAdListener(this.mAdViewListener);
                adView.loadAd();
            }
        }
        return convertView;
    }

    private int getPosition(int position) {
        if (!this.isAdType(position)) {
            int n2 = 0;
            for (int n3 : this.mAdPositions) {
                if (this.mAdLoadedCount == n2) break;
                if (n3 > position) continue;
                ++n2;
            }
            position -= n2;
        }
        return position;
    }

    public int getItemViewType(int position) {
        return this.isAdType(position) ? 853125 : this.mAdapter.getItemViewType(this.getPosition(position));
    }

    public int getViewTypeCount() {
        return this.mAdapter.getViewTypeCount() + Math.min(1, this.mAdLoadedCount);
    }

    public int getCount() {
        return this.mAdapter.getCount() != 0 ? this.mAdapter.getCount() + this.mAdLoadedCount : 0;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mAdapter.notifyDataSetChanged();
        if (this.mAdapter.getCount() != this.mListSize) {
            this.reload();
        }
    }

    public Object getItem(int position) {
        return !this.isAdType(position) ? this.mAdapter.getItem(this.getPosition(position)) : null;
    }

    public long getItemId(int position) {
        return this.isAdType(position) ? (long)((AdView)((Object)this.mAdViewsHolder.get(position))).getId() : this.mAdapter.getItemId(this.getPosition(position));
    }

    public boolean areAllItemsEnabled() {
        return this.mAdapter.areAllItemsEnabled();
    }

    public boolean hasStableIds() {
        return this.mAdapter.hasStableIds();
    }

    public boolean isEmpty() {
        return this.mAdapter.isEmpty();
    }

    public boolean isEnabled(int position) {
        return this.isAdType(position) || this.mAdapter.isEnabled(position);
    }

    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.mAdapter.notifyDataSetChanged();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mAdapter.registerDataSetObserver(observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mAdapter.unregisterDataSetObserver(observer);
    }

    public BaseAdapter getAdapter() {
        return this.mAdapter;
    }
}

