/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.private;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.private.ae;
import com.inlocomedia.android.ads.private.af;
import com.inlocomedia.android.ads.private.ag;
import com.inlocomedia.android.ads.private.ah;
import com.inlocomedia.android.ads.private.ai;
import com.inlocomedia.android.core.annotations.VisibleForTesting;
import com.inlocomedia.android.core.util.Validator;

public final class ba {
    public static void a(ah ah2) throws AdvertisementException {
        try {
            ba.a((ae)ah2);
            ba.c(ah2.a());
            Validator.notNullNorEmpty((String)ah2.l(), (String)"Native ad title");
            if (!Validator.isValidUrl((String)ah2.o()) && !Validator.isValidUrl((String)ah2.p())) {
                throw new IllegalArgumentException("Native ad image or icon.");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid native ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(ai ai2) throws AdvertisementException {
        try {
            ba.a((ae)ai2);
            ba.a(ai2.a());
            Validator.notNullNorEmpty((String)ai2.n(), (String)"Ad title");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid notification ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(ag ag2) throws AdvertisementException {
        try {
            ba.a((ae)ag2);
            ba.b(ag2.a());
            Validator.notNullNorEmpty((String)ag2.m(), (String)"DisplayAd html");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid display ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(af af2) throws AdvertisementException {
        try {
            ba.a((ae)af2);
            ba.d(af2.a());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid custom ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    @VisibleForTesting
    public static void a(ae ae2) {
        Validator.notNull((Object)ae2, (String)"Ad");
        Validator.notNullNorEmpty((String)ae2.f(), (String)"Ad id");
        Validator.notNullNorEmpty((String)ae2.d(), (String)"Ad visualization url");
        Validator.isValidUrl((String)ae2.d(), (String)"Ad visualization url");
        Validator.notNullNorEmpty((String)ae2.c(), (String)"Ad register click url");
        Validator.isValidUrl((String)ae2.c(), (String)"Ad register click url");
        Validator.notNullNorEmpty((String)ae2.b(), (String)"Ad back to application url");
        Validator.isValidUrl((String)ae2.b(), (String)"Ad back to application url");
        Validator.notNull((Object)((Object)ae2.a()), (String)"Ad type");
    }

    public static void a(AdView adView) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adView), (String)"Advertisement View");
            Validator.notNull((Object)((Object)adView.getType()), (String)"AdType");
            if (adView.getType().isNative()) {
                ba.a((View)adView);
            } else if (!adView.getType().isDisplay()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(View view) throws AdvertisementException {
        try {
            if (view.findViewById(R.id.ilm_title) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(R.id.ilm_image) == null && view.findViewById(R.id.ilm_icon) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            ba.b(view.findViewById(R.id.ilm_call_to_action), "'Call to Action' must extend from TextView");
            ba.b(view.findViewById(R.id.ilm_title), "'Title' must be a TextView");
            ba.b(view.findViewById(R.id.ilm_description), "'Description' must be a TextView");
            ba.b(view.findViewById(R.id.ilm_highlight), "'Highlight' must be a TextView");
            ba.b(view.findViewById(R.id.ilm_offer), "'Offer' must be a TextView");
            ba.b(view.findViewById(R.id.ilm_expiration), "'Expiration' must be a TextView");
            ba.a(view.findViewById(R.id.ilm_image), "'Image' must be a ImageView");
            ba.a(view.findViewById(R.id.ilm_icon), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native AdView: " + runtimeException.toString(), runtimeException);
        }
    }

    private static void a(View view, String string2) {
        if (view != null && !(view instanceof ImageView)) {
            throw new IllegalArgumentException("Invalid image view type." + string2 + " must be a subclass of " + ImageView.class.getCanonicalName());
        }
    }

    private static void b(View view, String string2) {
        if (view != null && !(view instanceof TextView)) {
            throw new IllegalArgumentException("Invalid text view type." + string2 + " must be a subclass of " + TextView.class.getCanonicalName());
        }
    }

    private static void a(AdType adType) {
        if (!adType.isNotification()) {
            throw new IllegalArgumentException("Notification ad type invalid/missing on validation case " + adType.getValue());
        }
    }

    private static void b(AdType adType) {
        if (!adType.isDisplay()) {
            throw new IllegalArgumentException("Display ad type invalid/missing on validation case " + adType.getValue());
        }
    }

    private static void c(AdType adType) {
        if (!adType.isNative()) {
            throw new IllegalArgumentException("Native ad type invalid/missing on validation case " + adType.getValue());
        }
    }

    private static void d(AdType adType) {
        if (!adType.isCustom()) {
            throw new IllegalArgumentException("Custom ad type invalid/missing on validation case " + adType.getValue());
        }
    }
}

