/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.exception.AdvertisementsUnavailableException;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.communication.exception.TimeoutException;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.DevLogger;

public enum AdError {
    NO_FILL("No Fill"),
    INVALID_REQUEST("Invalid Request"),
    NETWORK_NOT_AVAILABLE("Network not available"),
    UNAUTHORIZED("Unauthorized"),
    INTERNAL_ERROR("Internal Error"),
    TIMEOUT("Timeout"),
    GOOGLE_PLAY_SERVICES_NOT_FOUND("GooglePlayServices not found"),
    INVALID_SDK_VERSION("Android SDK version below 14");

    private String value;

    private AdError(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static AdError fromThrowable(Throwable t2) {
        AdError adError = t2 instanceof TimeoutException ? TIMEOUT : (t2 instanceof AdvertisementRequestException ? INVALID_REQUEST : (t2 instanceof NetworkUnavailableException ? NETWORK_NOT_AVAILABLE : (t2 instanceof AdvertisementsUnavailableException ? NO_FILL : (t2 instanceof UnauthorizedException ? UNAUTHORIZED : INTERNAL_ERROR))));
        return adError;
    }

    public static void logError(Throwable t2) {
        if (t2 instanceof AdvertisementRequestException) {
            DevLogger.w((String)InLocoMediaException.getFormattedMessage((Throwable)t2));
        } else if (t2 instanceof UnauthorizedException) {
            DevLogger.w((String)InLocoMediaException.getFormattedMessage((Throwable)t2));
        } else if (!(t2 instanceof TimeoutException || t2 instanceof NetworkUnavailableException || t2 instanceof AdvertisementsUnavailableException)) {
            DevLogger.w((String)("AdRequest has failed with error: " + InLocoMediaException.getFormattedMessage((Throwable)t2)));
        }
    }
}

