/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.mediation.google.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.util.Log;
import com.inlocomedia.android.mediation.google.utils.DrawableDownloadListener;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DownloadDrawablesAsync
extends AsyncTask<Object, Void, HashMap<String, Drawable>> {
    public static final String KEY_IMAGE = "image_key";
    public static final String KEY_ICON = "icon_key";
    private static final long DRAWABLE_FUTURE_TIMEOUT_SECONDS = 10L;
    private DrawableDownloadListener listener;

    public DownloadDrawablesAsync(DrawableDownloadListener listener) {
        this.listener = listener;
    }

    protected HashMap<String, Drawable> doInBackground(Object ... params) {
        HashMap urlsMap = (HashMap)params[0];
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<Drawable> imageDrawableFuture = this.getDrawableFuture((URL)urlsMap.get(KEY_IMAGE), executorService);
        Future<Drawable> iconDrawableFuture = this.getDrawableFuture((URL)urlsMap.get(KEY_ICON), executorService);
        try {
            Drawable imageDrawable = imageDrawableFuture.get(10L, TimeUnit.SECONDS);
            Drawable iconDrawable = iconDrawableFuture.get(10L, TimeUnit.SECONDS);
            HashMap<String, Drawable> drawablesMap = new HashMap<String, Drawable>();
            drawablesMap.put(KEY_IMAGE, imageDrawable);
            drawablesMap.put(KEY_ICON, iconDrawable);
            return drawablesMap;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Log.d((String)"InLocoMedia", (String)"Native ad images failed to download");
            return null;
        }
    }

    private Future<Drawable> getDrawableFuture(final URL url, ExecutorService executorService) {
        return executorService.submit(new Callable<Drawable>(){

            @Override
            public Drawable call() throws Exception {
                InputStream in = url.openStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
                bitmap.setDensity(160);
                return new BitmapDrawable(Resources.getSystem(), bitmap);
            }
        });
    }

    protected void onPostExecute(HashMap<String, Drawable> drawablesMap) {
        super.onPostExecute(drawablesMap);
        if (drawablesMap != null) {
            this.listener.onDownloadSuccess(drawablesMap);
        } else {
            this.listener.onDownloadFailure();
        }
    }
}

