/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.mediation.google;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.nativeads.NativeAdManager;
import com.inlocomedia.android.ads.nativeads.NativeAdResponse;
import com.inlocomedia.android.mediation.google.Utils;
import com.inlocomedia.android.mediation.google.utils.DownloadDrawablesAsync;
import com.inlocomedia.android.mediation.google.utils.DrawableDownloadListener;
import com.inlocomedia.android.mediation.google.utils.InLocoContentNativeAdMapper;
import com.inlocomedia.android.mediation.google.utils.InLocoUnifiedNativeAdMapper;
import com.inlocomedia.android.mediation.google.utils.NativeAdMapperInterface;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class InLocoMediaNativeAdapter
implements MediationNativeAdapter {
    private final String requestAgent;
    private NativeAdMapperInterface nativeAdMapper;

    public InLocoMediaNativeAdapter(String requestAgent) {
        this.requestAgent = requestAgent;
    }

    public void requestNativeAd(final Context context, final MediationNativeListener listener, Bundle serverParameters, final NativeMediationAdRequest mediationAdRequest, Bundle mediationExtras) {
        String adUnitId = serverParameters.getString("ad_unit_id");
        final NativeAdOptions options = mediationAdRequest.getNativeAdOptions();
        if (mediationAdRequest.isContentAdRequested() || mediationAdRequest.isUnifiedNativeAdRequested()) {
            AdRequest adRequest = Utils.createAdRequest((MediationAdRequest)mediationAdRequest, adUnitId, this.requestAgent);
            NativeAdManager.requestAd((Context)context, (AdRequest)adRequest, (NativeAdManager.RequestListener)new NativeAdManager.RequestListener(){

                public void onAdReceived(final NativeAdResponse response) {
                    HashMap<String, URL> map = new HashMap<String, URL>();
                    try {
                        map.put("icon_key", new URL(response.getIconUrl()));
                        map.put("image_key", new URL(response.getMainImageUrl()));
                    }
                    catch (MalformedURLException e) {
                        Log.w((String)"InLocoMedia", (String)"Invalid ad response received for In Loco Media Native Ads. Image URLs are invalid");
                        listener.onAdFailedToLoad((MediationNativeAdapter)InLocoMediaNativeAdapter.this, 0);
                        return;
                    }
                    DrawableDownloadListener imagesListener = new DrawableDownloadListener(){

                        @Override
                        public void onDownloadSuccess(HashMap<String, Drawable> drawableMap) {
                            if (mediationAdRequest.isUnifiedNativeAdRequested()) {
                                InLocoUnifiedNativeAdMapper mapper = new InLocoUnifiedNativeAdMapper(context, response, drawableMap);
                                InLocoMediaNativeAdapter.this.nativeAdMapper = mapper;
                                listener.onAdLoaded((MediationNativeAdapter)InLocoMediaNativeAdapter.this, (UnifiedNativeAdMapper)mapper);
                            } else {
                                InLocoContentNativeAdMapper mapper = new InLocoContentNativeAdMapper(context, response, drawableMap);
                                InLocoMediaNativeAdapter.this.nativeAdMapper = mapper;
                                listener.onAdLoaded((MediationNativeAdapter)InLocoMediaNativeAdapter.this, (NativeAdMapper)mapper);
                            }
                        }

                        @Override
                        public void onDownloadFailure() {
                            listener.onAdFailedToLoad((MediationNativeAdapter)InLocoMediaNativeAdapter.this, 0);
                        }
                    };
                    if (options != null && options.shouldReturnUrlsForImageAssets()) {
                        imagesListener.onDownloadSuccess(new HashMap<String, Drawable>());
                    } else {
                        new DownloadDrawablesAsync(imagesListener).execute(new Object[]{map});
                    }
                }

                public void onAdError(AdError adError) {
                    listener.onAdFailedToLoad((MediationNativeAdapter)InLocoMediaNativeAdapter.this, Utils.adErrorToAdMobError(adError));
                }
            });
        } else {
            listener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
        }
    }

    public void onDestroy() {
        if (this.nativeAdMapper != null) {
            this.nativeAdMapper.destroy();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }
}

