/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.mediation.google;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitial;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.interstitial.InterstitialAd;
import com.inlocomedia.android.ads.interstitial.InterstitialAdListener;
import com.inlocomedia.android.mediation.google.Utils;

public class InLocoMediaInterstitialAdapter
implements CustomEventInterstitial {
    public static final String TAG = "InLocoMedia";
    private InterstitialAd mInterstitialAd;
    private String mRequestAgent;

    public InLocoMediaInterstitialAdapter(String requestAgent) {
        this.mRequestAgent = requestAgent;
    }

    public void requestInterstitialAd(Context context, final CustomEventInterstitialListener listener, String serverParameter, MediationAdRequest mediationAdRequest, Bundle bundle) {
        Utils.setupInLocoMedia(context, serverParameter);
        this.mInterstitialAd = new InterstitialAd(context);
        this.mInterstitialAd.setInterstitialAdListener(new InterstitialAdListener(){

            public void onAdReady(InterstitialAd ad) {
                Log.i((String)InLocoMediaInterstitialAdapter.TAG, (String)"Interstitial ready");
                listener.onAdLoaded();
            }

            public void onAdOpened(InterstitialAd ad) {
                Log.i((String)InLocoMediaInterstitialAdapter.TAG, (String)"Interstitial opened");
                listener.onAdOpened();
            }

            public void onAdError(InterstitialAd ad, AdError error) {
                Log.i((String)InLocoMediaInterstitialAdapter.TAG, (String)("Interstitial error: " + error));
                listener.onAdFailedToLoad(Utils.adErrorToAdMobError(error));
            }

            public void onAdClosed(InterstitialAd ad) {
                Log.i((String)InLocoMediaInterstitialAdapter.TAG, (String)"Interstitial closed");
                listener.onAdClosed();
            }

            public void onAdLeftApplication(InterstitialAd ad) {
                Log.i((String)InLocoMediaInterstitialAdapter.TAG, (String)"Interstitial left application");
                listener.onAdLeftApplication();
            }
        });
        String adUnitId = Utils.getAdUnitId(serverParameter);
        this.mInterstitialAd.loadAd(Utils.createAdRequest(mediationAdRequest, adUnitId, this.mRequestAgent));
        Log.i((String)TAG, (String)"Interstitial requested");
    }

    public void showInterstitial() {
        if (this.mInterstitialAd != null && this.mInterstitialAd.isLoaded()) {
            this.mInterstitialAd.show();
        }
    }

    public void onDestroy() {
    }

    public void onPause() {
    }

    public void onResume() {
    }
}

