/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.JdbcAscii;
import com.ing.data.cassandra.jdbc.types.JdbcBoolean;
import com.ing.data.cassandra.jdbc.types.JdbcByte;
import com.ing.data.cassandra.jdbc.types.JdbcBytes;
import com.ing.data.cassandra.jdbc.types.JdbcCounterColumn;
import com.ing.data.cassandra.jdbc.types.JdbcDate;
import com.ing.data.cassandra.jdbc.types.JdbcDecimal;
import com.ing.data.cassandra.jdbc.types.JdbcDouble;
import com.ing.data.cassandra.jdbc.types.JdbcDuration;
import com.ing.data.cassandra.jdbc.types.JdbcFloat;
import com.ing.data.cassandra.jdbc.types.JdbcInetAddress;
import com.ing.data.cassandra.jdbc.types.JdbcInt32;
import com.ing.data.cassandra.jdbc.types.JdbcInteger;
import com.ing.data.cassandra.jdbc.types.JdbcLexicalUUID;
import com.ing.data.cassandra.jdbc.types.JdbcList;
import com.ing.data.cassandra.jdbc.types.JdbcLong;
import com.ing.data.cassandra.jdbc.types.JdbcMap;
import com.ing.data.cassandra.jdbc.types.JdbcOther;
import com.ing.data.cassandra.jdbc.types.JdbcSet;
import com.ing.data.cassandra.jdbc.types.JdbcShort;
import com.ing.data.cassandra.jdbc.types.JdbcTime;
import com.ing.data.cassandra.jdbc.types.JdbcTimeUUID;
import com.ing.data.cassandra.jdbc.types.JdbcTimestamp;
import com.ing.data.cassandra.jdbc.types.JdbcTuple;
import com.ing.data.cassandra.jdbc.types.JdbcUTF8;
import com.ing.data.cassandra.jdbc.types.JdbcUUID;
import com.ing.data.cassandra.jdbc.types.JdbcUdt;
import com.ing.data.cassandra.jdbc.types.JdbcVector;
import java.util.HashMap;
import java.util.Map;

public final class TypesMap {
    private static final Map<String, AbstractJdbcType<?>> TYPES_MAP = new HashMap();

    private TypesMap() {
    }

    public static AbstractJdbcType<?> getTypeForComparator(String comparator) {
        if (comparator != null && !comparator.contains(".")) {
            return TYPES_MAP.getOrDefault("org.apache.cassandra.db.marshal." + comparator.toLowerCase(), JdbcOther.INSTANCE);
        }
        return TYPES_MAP.getOrDefault(comparator, JdbcOther.INSTANCE);
    }

    static {
        TYPES_MAP.put("org.apache.cassandra.db.marshal.AsciiType", JdbcAscii.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.BooleanType", JdbcBoolean.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.BytesType", JdbcBytes.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.ByteType", JdbcByte.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.CounterColumnType", JdbcCounterColumn.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DateType", JdbcDate.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DecimalType", JdbcDecimal.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DoubleType", JdbcDouble.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DurationType", JdbcDuration.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.FloatType", JdbcFloat.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.InetAddressType", JdbcInetAddress.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.IntegerType", JdbcInteger.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.Int32Type", JdbcInt32.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.LexicalUUIDType", JdbcLexicalUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.LongType", JdbcLong.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.ListType", JdbcList.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.MapType", JdbcMap.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.SetType", JdbcSet.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.ShortType", JdbcShort.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TimeType", JdbcTime.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TimestampType", JdbcTimestamp.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TimeUUIDType", JdbcTimeUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TupleType", JdbcTuple.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.UserType", JdbcUdt.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.UTF8Type", JdbcUTF8.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.UUIDType", JdbcUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.VectorType", JdbcVector.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.ascii", JdbcAscii.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.bigint", JdbcLong.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.blob", JdbcBytes.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.boolean", JdbcBoolean.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.counter", JdbcLong.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.date", JdbcDate.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.decimal", JdbcDecimal.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.double", JdbcDouble.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.duration", JdbcDuration.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.float", JdbcFloat.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.inet", JdbcInetAddress.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.int", JdbcInt32.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.list", JdbcList.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.map", JdbcList.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.set", JdbcList.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.smallint", JdbcShort.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.text", JdbcUTF8.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.time", JdbcTime.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.timestamp", JdbcTimestamp.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.timeuuid", JdbcTimeUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.tinyint", JdbcByte.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.tuple", JdbcTuple.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.udt", JdbcUdt.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.uuid", JdbcUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.varchar", JdbcUTF8.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.varint", JdbcInteger.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.vector", JdbcVector.INSTANCE);
    }
}

