/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.GetCallback;
import com.parse.Parse;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseRole;
import com.parse.ParseUser;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseACL {
    private static final String PUBLIC_KEY = "*";
    private static final String UNRESOLVED_KEY = "*unresolved";
    private static ParseACL defaultACL;
    private static boolean defaultACLUsesCurrentUser;
    private static WeakReference<ParseUser> lastCurrentUser;
    private static ParseACL defaultACLWithCurrentUser;
    private boolean shared;
    private ParseUser unresolvedUser;
    private JSONObject permissionsById = new JSONObject();

    public static void setDefaultACL(ParseACL acl, boolean withAccessForCurrentUser) {
        defaultACLWithCurrentUser = null;
        lastCurrentUser = null;
        if (acl != null) {
            ParseACL newDefaultACL = acl.copy();
            newDefaultACL.setShared(true);
            defaultACL = newDefaultACL;
            defaultACLUsesCurrentUser = withAccessForCurrentUser;
        } else {
            defaultACL = null;
        }
    }

    static ParseACL getDefaultACL() {
        ParseUser currentUser = ParseUser.getCurrentUser();
        if (defaultACLUsesCurrentUser && defaultACL != null && currentUser != null) {
            ParseUser last;
            ParseUser parseUser = last = lastCurrentUser != null ? (ParseUser)lastCurrentUser.get() : null;
            if (last != currentUser) {
                ParseACL newDefaultACLWithCurrentUser = defaultACL.copy();
                newDefaultACLWithCurrentUser.setShared(true);
                newDefaultACLWithCurrentUser.setReadAccess(currentUser, true);
                newDefaultACLWithCurrentUser.setWriteAccess(currentUser, true);
                defaultACLWithCurrentUser = newDefaultACLWithCurrentUser;
                lastCurrentUser = new WeakReference<ParseUser>(currentUser);
            }
            return defaultACLWithCurrentUser;
        }
        return defaultACL;
    }

    public ParseACL() {
    }

    ParseACL copy() {
        ParseACL copy = new ParseACL();
        try {
            copy.permissionsById = new JSONObject(this.permissionsById.toString());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        copy.unresolvedUser = this.unresolvedUser;
        if (this.unresolvedUser != null) {
            this.unresolvedUser.registerSaveListener(new UserResolutionListener(copy));
        }
        return copy;
    }

    boolean isShared() {
        return this.shared;
    }

    void setShared(boolean shared) {
        this.shared = shared;
    }

    JSONObject toJSONObject(ParseObjectEncodingStrategy objectEncoder) {
        JSONObject json;
        try {
            json = new JSONObject(this.permissionsById.toString());
            if (this.unresolvedUser != null) {
                Object encoded = Parse.encode(this.unresolvedUser, objectEncoder);
                json.put("unresolvedUser", encoded);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    static ParseACL createACLFromJSONObject(JSONObject object, ParseDecoder decoder) {
        ParseACL acl = new ParseACL();
        for (String key : Parse.keys(object)) {
            JSONObject permissions;
            if (key.equals("unresolvedUser")) {
                JSONObject unresolvedUser;
                try {
                    unresolvedUser = object.getJSONObject(key);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                acl.unresolvedUser = (ParseUser)decoder.decode(unresolvedUser);
                continue;
            }
            String userId = key;
            try {
                permissions = object.getJSONObject(userId);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not decode ACL: " + e.getMessage());
            }
            for (String accessType : Parse.keys(permissions)) {
                acl.setAccess(accessType, userId, true);
            }
        }
        return acl;
    }

    public ParseACL(ParseUser owner) {
        this();
        this.setReadAccess(owner, true);
        this.setWriteAccess(owner, true);
    }

    private void resolveUser(ParseUser user) {
        if (user != this.unresolvedUser) {
            return;
        }
        try {
            if (this.permissionsById.has(UNRESOLVED_KEY)) {
                this.permissionsById.put(user.getObjectId(), this.permissionsById.get(UNRESOLVED_KEY));
                this.permissionsById.remove(UNRESOLVED_KEY);
            }
            this.unresolvedUser = null;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    boolean hasUnresolvedUser() {
        return this.unresolvedUser != null;
    }

    private void setAccess(String accessType, String userId, boolean allowed) {
        try {
            JSONObject permissions = this.permissionsById.optJSONObject(userId);
            if (permissions == null) {
                if (!allowed) {
                    return;
                }
                permissions = new JSONObject();
                this.permissionsById.put(userId, (Object)permissions);
            }
            if (allowed) {
                permissions.put(accessType, true);
            } else {
                permissions.remove(accessType);
                if (permissions.length() == 0) {
                    this.permissionsById.remove(userId);
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON failure with ACL: " + e.getMessage());
        }
    }

    private boolean getAccess(String accessType, String userId) {
        try {
            JSONObject permissions = this.permissionsById.optJSONObject(userId);
            if (permissions == null) {
                return false;
            }
            if (!permissions.has(accessType)) {
                return false;
            }
            return permissions.getBoolean(accessType);
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON failure with ACL: " + e.getMessage());
        }
    }

    public void setPublicReadAccess(boolean allowed) {
        this.setReadAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicReadAccess() {
        return this.getReadAccess(PUBLIC_KEY);
    }

    public void setPublicWriteAccess(boolean allowed) {
        this.setWriteAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicWriteAccess() {
        return this.getWriteAccess(PUBLIC_KEY);
    }

    public void setReadAccess(String userId, boolean allowed) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot setReadAccess for null userId");
        }
        this.setAccess("read", userId, allowed);
    }

    public boolean getReadAccess(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot getReadAccess for null userId");
        }
        return this.getAccess("read", userId);
    }

    public void setWriteAccess(String userId, boolean allowed) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot setWriteAccess for null userId");
        }
        this.setAccess("write", userId, allowed);
    }

    public boolean getWriteAccess(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("cannot getWriteAccess for null userId");
        }
        return this.getAccess("write", userId);
    }

    public void setReadAccess(ParseUser user, boolean allowed) {
        if (user.getObjectId() == null) {
            if (user.isLazy()) {
                this.setUnresolvedReadAccess(user, allowed);
                return;
            }
            throw new IllegalArgumentException("cannot setReadAccess for a user with null id");
        }
        this.setReadAccess(user.getObjectId(), allowed);
    }

    private void setUnresolvedReadAccess(ParseUser user, boolean allowed) {
        this.prepareUnresolvedUser(user);
        this.setReadAccess(UNRESOLVED_KEY, allowed);
    }

    private void setUnresolvedWriteAccess(ParseUser user, boolean allowed) {
        this.prepareUnresolvedUser(user);
        this.setWriteAccess(UNRESOLVED_KEY, allowed);
    }

    private void prepareUnresolvedUser(ParseUser user) {
        if (this.unresolvedUser != user) {
            this.permissionsById.remove(UNRESOLVED_KEY);
            this.unresolvedUser = user;
            user.registerSaveListener(new UserResolutionListener(this));
        }
    }

    public boolean getReadAccess(ParseUser user) {
        if (user == this.unresolvedUser) {
            return this.getReadAccess(UNRESOLVED_KEY);
        }
        if (user.isLazy()) {
            return false;
        }
        if (user.getObjectId() == null) {
            throw new IllegalArgumentException("cannot getReadAccess for a user with null id");
        }
        return this.getReadAccess(user.getObjectId());
    }

    public void setWriteAccess(ParseUser user, boolean allowed) {
        if (user.getObjectId() == null) {
            if (user.isLazy()) {
                this.setUnresolvedWriteAccess(user, allowed);
                return;
            }
            throw new IllegalArgumentException("cannot setWriteAccess for a user with null id");
        }
        this.setWriteAccess(user.getObjectId(), allowed);
    }

    public boolean getWriteAccess(ParseUser user) {
        if (user == this.unresolvedUser) {
            return this.getWriteAccess(UNRESOLVED_KEY);
        }
        if (user.isLazy()) {
            return false;
        }
        if (user.getObjectId() == null) {
            throw new IllegalArgumentException("cannot getWriteAccess for a user with null id");
        }
        return this.getWriteAccess(user.getObjectId());
    }

    public boolean getRoleReadAccess(String roleName) {
        return this.getReadAccess("role:" + roleName);
    }

    public void setRoleReadAccess(String roleName, boolean allowed) {
        this.setReadAccess("role:" + roleName, allowed);
    }

    public boolean getRoleWriteAccess(String roleName) {
        return this.getWriteAccess("role:" + roleName);
    }

    public void setRoleWriteAccess(String roleName, boolean allowed) {
        this.setWriteAccess("role:" + roleName, allowed);
    }

    private static void validateRoleState(ParseRole role) {
        if (role.getObjectId() == null) {
            throw new IllegalArgumentException("Roles must be saved to the server before they can be used in an ACL.");
        }
    }

    public boolean getRoleReadAccess(ParseRole role) {
        ParseACL.validateRoleState(role);
        return this.getRoleReadAccess(role.getName());
    }

    public void setRoleReadAccess(ParseRole role, boolean allowed) {
        ParseACL.validateRoleState(role);
        this.setRoleReadAccess(role.getName(), allowed);
    }

    public boolean getRoleWriteAccess(ParseRole role) {
        ParseACL.validateRoleState(role);
        return this.getRoleWriteAccess(role.getName());
    }

    public void setRoleWriteAccess(ParseRole role, boolean allowed) {
        ParseACL.validateRoleState(role);
        this.setRoleWriteAccess(role.getName(), allowed);
    }

    private static class UserResolutionListener
    extends GetCallback<ParseObject> {
        private final WeakReference<ParseACL> parent;

        public UserResolutionListener(ParseACL parent) {
            this.parent = new WeakReference<ParseACL>(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(ParseObject object, ParseException e) {
            try {
                ParseACL parent = (ParseACL)this.parent.get();
                if (parent != null) {
                    parent.resolveUser((ParseUser)object);
                }
            }
            finally {
                object.unregisterSaveListener(this);
            }
        }
    }
}

