/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.providers;

import com.infoedge.jrandomizer.exceptions.RandomDataGeneratorException;
import com.infoedge.jrandomizer.providers.Provider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.WeakHashMap;

public class ProviderFactory {
    private WeakHashMap<Provider<?>, Object> mProvidersMap = new WeakHashMap();
    private static ProviderFactory mInstance;

    private ProviderFactory() {
    }

    public static ProviderFactory getInstance() {
        if (mInstance == null) {
            mInstance = new ProviderFactory();
        }
        return mInstance;
    }

    public <T extends Provider, D> T provider(Class<T> clazz, Class<D> dataClass) {
        Provider<D> provider = this.createInstance(clazz, dataClass);
        if (!this.mProvidersMap.containsKey(provider)) {
            this.mProvidersMap.put(provider, new Object());
        } else {
            Set<Provider<?>> providers = this.mProvidersMap.keySet();
            for (Provider<?> providerKey : providers) {
                if (!providerKey.equals(provider)) continue;
                provider = null;
                return (T)providerKey;
            }
        }
        return (T)provider;
    }

    private <T extends Provider, D> Provider<D> createInstance(Class<T> clazz, Class<D> dataClass) {
        Provider target = null;
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(Class.class);
            if (Modifier.isPublic(constructor.getModifiers())) {
                String message = String.format("All Constructors of class %s should be private", clazz.getSimpleName());
                throw new RandomDataGeneratorException(message);
            }
            constructor.setAccessible(true);
            target = (Provider)constructor.newInstance(dataClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return target;
    }
}

