/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Number;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class NumberGenerator
extends GenerationRule<Number, Double> {
    private long min;
    private long max;
    private int decimalPlaces;

    public NumberGenerator(Number annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
    }

    @Override
    public Double generate() {
        Number annotation = (Number)this.getAnnotation();
        this.min = annotation.min();
        this.max = annotation.max();
        this.decimalPlaces = annotation.decimals();
        double number = (double)this.min + Math.random() * (double)(this.max - this.min + 1L);
        if (this.decimalPlaces > 0) {
            number = NumberGenerator.round(number, this.decimalPlaces);
        }
        return number;
    }

    private static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

