/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Money;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MoneyGenerator
extends GenerationRule<Money, String> {
    private Money.In moneyIn;
    private double min;
    private double max;

    public MoneyGenerator(Money annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.moneyIn = annotation.in();
        this.min = annotation.min();
        this.max = annotation.max();
    }

    @Override
    public String generate() {
        String randomMoney = new BigDecimal(this.min + Math.random() * (this.max - this.min + 1.0)).setScale(2, RoundingMode.HALF_UP).toString();
        String currencySymbol = this.currencySymbol(this.moneyIn);
        return String.format("%s%s", currencySymbol, randomMoney);
    }

    private String currencySymbol(Money.In in) {
        if (in == Money.In.RANDOM) {
            int randomIndex = this.getRandom().nextInt(Money.In.values().length - 1);
            in = Money.In.values()[randomIndex];
        }
        return in.getCurrencySymbol();
    }
}

