/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Guid;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.GuidProvider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class GuidGenerator
extends GenerationRule<Guid, String> {
    private GuidProvider mProvider = this.providerFactory().provider(GuidProvider.class, GuidProvider.GuidRecord[].class);
    private boolean mEssentiallyUnique;
    private String firstPart = null;

    public GuidGenerator(Guid annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.mEssentiallyUnique = annotation.essentiallyUnique();
    }

    @Override
    public String generate() {
        GuidProvider.GuidRecord[] guids = (GuidProvider.GuidRecord[])this.mProvider.provide();
        int random = this.getRandom().nextInt(guids.length);
        GuidProvider.GuidRecord randomGuid = guids[random];
        if (this.mEssentiallyUnique) {
            if (this.firstPart == null) {
                this.firstPart = randomGuid.firstPart;
            }
        } else {
            this.firstPart = randomGuid.firstPart;
        }
        return this.firstPart + randomGuid.lastPart;
    }
}

