/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.DummyImageUrl;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class DummyImageUrlGenerator
extends GenerationRule<DummyImageUrl, String> {
    private final String IMAGE_URL_TEMPLATE = "http://dummyimage.com/{width}x{height}/{background-color}.{format}?text={text}";
    private int width = 100;
    private int height = 100;
    private DummyImageUrl.Format format = DummyImageUrl.Format.RANDOM;

    public DummyImageUrlGenerator(DummyImageUrl annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.width = annotation.width();
        this.height = annotation.height();
        this.format = annotation.format();
    }

    @Override
    public String generate() {
        String randomColor = this.randomBackgroundColor();
        return "http://dummyimage.com/{width}x{height}/{background-color}.{format}?text={text}".replace("{width}", String.valueOf(this.width)).replace("{height}", String.valueOf(this.height)).replace("{format}", this.imageFormat(this.format)).replace("{background-color}", randomColor).replace("{text}", randomColor);
    }

    private String randomBackgroundColor() {
        int randomCode = this.getRandom().nextInt(0x1000000);
        return Integer.toHexString(randomCode);
    }

    private String imageFormat(DummyImageUrl.Format format) {
        if (format == DummyImageUrl.Format.RANDOM) {
            int randomIndex = this.getRandom().nextInt(3);
            switch (randomIndex) {
                case 0: {
                    return DummyImageUrl.Format.JPG.getLabel();
                }
                case 1: {
                    return DummyImageUrl.Format.PNG.getLabel();
                }
                case 2: {
                    return DummyImageUrl.Format.GIF.getLabel();
                }
            }
        }
        return format.getLabel();
    }
}

