/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.DateValue;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateValueGenerator
extends GenerationRule<DateValue, String> {
    private DateValue.Format mDateFormat;
    private String mCustomDateFormat;
    private String mFrom;
    private String mTo;
    private Date mFromDate;
    private Date mToDate;

    public DateValueGenerator(DateValue annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.mDateFormat = annotation.format();
        this.mCustomDateFormat = annotation.customFormat();
        this.mFrom = annotation.from();
        this.mTo = annotation.to();
        this.mFromDate = this.fromStringToDate(this.isDateFormatvalid(this.mCustomDateFormat) ? this.mCustomDateFormat : this.mDateFormat.getValue(), this.mFrom);
        this.mToDate = this.fromStringToDate(this.isDateFormatvalid(this.mCustomDateFormat) ? this.mCustomDateFormat : this.mDateFormat.getValue(), this.mTo);
    }

    @Override
    public String generate() {
        Date randomDate = this.randomDate(this.mFromDate, this.mToDate);
        return this.fromDateToString(this.isDateFormatvalid(this.mCustomDateFormat) ? this.mCustomDateFormat : this.mDateFormat.getValue(), randomDate);
    }

    private Date fromStringToDate(String format, String value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
        Date date = null;
        try {
            date = dateFormat.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
            date = Calendar.getInstance().getTime();
        }
        return date;
    }

    private String fromDateToString(String format, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
        String dateString = null;
        dateString = dateFormat.format(date);
        return dateString;
    }

    private Date randomDate(Date fromDate, Date toDate) {
        long fromTime = fromDate.getTime();
        long toTime = toDate.getTime();
        long diff = toTime - fromTime + 1L;
        if (diff <= 0L) {
            return fromDate;
        }
        long randomTime = fromTime + (long)(Math.random() * (double)diff);
        return new Date(randomTime);
    }

    private boolean isDateFormatvalid(String format) {
        return format != null && !format.isEmpty();
    }
}

