/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Avatar;
import com.infoedge.jrandomizer.exceptions.RandomDataGeneratorException;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.AvatarProvider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class AvatarGenerator
extends GenerationRule<Avatar, String> {
    private AvatarProvider mProvider;
    private int width = ((Avatar)this.getAnnotation()).width();
    private int height = ((Avatar)this.getAnnotation()).height();
    private Avatar.Format format = ((Avatar)this.getAnnotation()).format();

    public AvatarGenerator(Avatar annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.handleInvalidDimension(annotation.width());
        this.handleInvalidDimension(annotation.height());
        this.mProvider = this.providerFactory().provider(AvatarProvider.class, String[].class);
    }

    @Override
    public String generate() {
        String[] avatarUrls = this.mProvider.provide();
        int index = this.getRandom().nextInt(avatarUrls.length);
        String avatarUrl = avatarUrls[index];
        avatarUrl = avatarUrl.replaceAll("\\{width\\}", String.valueOf(this.width)).replaceAll("\\{height\\}", String.valueOf(this.height));
        String formatLabel = "";
        formatLabel = this.format == Avatar.Format.RANDOM ? this.randomFormat() : ((Avatar)this.getAnnotation()).format().getLabel();
        return avatarUrl.replaceAll("\\{format\\}", formatLabel);
    }

    private String randomFormat() {
        int random = this.getRandom().nextInt(3);
        switch (random) {
            case 0: {
                return Avatar.Format.PNG.getLabel();
            }
            case 1: {
                return Avatar.Format.BMP.getLabel();
            }
            case 2: {
                return Avatar.Format.JPG.getLabel();
            }
        }
        return Avatar.Format.PNG.getLabel();
    }

    private void handleInvalidDimension(int dimension) {
        if (dimension < 0 || dimension > 2000) {
            throw new RandomDataGeneratorException("Size of dimension should be between 0 and 2000");
        }
    }
}

