/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.AppVersion;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class AppVersionGenerator
extends GenerationRule<AppVersion, String> {
    private int minVersion;
    private int maxVersion;

    public AppVersionGenerator(AppVersion annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.minVersion = annotation.min();
        this.maxVersion = annotation.max();
        if (this.maxVersion < this.minVersion) {
            this.maxVersion = this.minVersion;
        }
    }

    @Override
    public String generate() {
        int majorVersion = this.minVersion + this.getRandom().nextInt(this.maxVersion - this.minVersion + 1);
        int parts = this.getRandom().nextInt(3);
        StringBuilder appVersion = new StringBuilder(String.valueOf(majorVersion));
        for (int i = 0; i < parts; ++i) {
            int subversion = this.getRandom().nextInt(10);
            appVersion.append(".").append(subversion);
        }
        return appVersion.toString();
    }
}

