/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer;

import com.infoedge.jrandomizer.adapters.ConversionAdapter;
import com.infoedge.jrandomizer.annotations.CollectionDescriptor;
import com.infoedge.jrandomizer.annotations.CustomGenerator;
import com.infoedge.jrandomizer.annotations.GenerateUsing;
import com.infoedge.jrandomizer.annotations.Mapping;
import com.infoedge.jrandomizer.annotations.ReferenceRecord;
import com.infoedge.jrandomizer.annotations.ReferencedRecord;
import com.infoedge.jrandomizer.exceptions.RandomDataGeneratorException;
import com.infoedge.jrandomizer.generators.DelegateGenerationRule;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.generators.InvalidGenerator;
import com.infoedge.jrandomizer.generators.RandomArrayGenerator;
import com.infoedge.jrandomizer.generators.RandomListGenerator;
import com.infoedge.jrandomizer.generators.ReferenceRecordGenerator;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class Reflector {
    static List<Field> getValidTargetAnnotatedFields(Class<?> clazz) {
        ArrayList<Field> targetFields = new ArrayList<Field>();
        List<Field> allTargetFields = Reflector.getAllTargetFields(clazz);
        block0: for (Field field : allTargetFields) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!Reflector.isValidTargetAnnotatedField(annotation.annotationType())) continue;
                targetFields.add(field);
                continue block0;
            }
        }
        return targetFields;
    }

    private static List<Field> getAllTargetFields(Class<?> controllerClass) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Reflector.getFields(controllerClass));
        Class<?> superClass = controllerClass.getSuperclass();
        while (!superClass.equals(Object.class)) {
            List<Field> viewFields = Reflector.getFields(superClass);
            if (viewFields.size() > 0) {
                allFields.addAll(viewFields);
            }
            superClass = superClass.getSuperclass();
        }
        return allFields;
    }

    private static List<Field> getFields(Class<?> clazz) {
        Field[] declaredFields;
        ArrayList<Field> viewFields = new ArrayList<Field>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            viewFields.add(field);
        }
        return viewFields;
    }

    static Object createInstance(Class<?> clazz) {
        Object target = null;
        try {
            target = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return target;
    }

    private static GenerateUsing getGenerateUsingAnnotation(Class<? extends Annotation> annotationType) {
        Annotation[] declaredAnnotations;
        GenerateUsing generateUsing = null;
        for (Annotation annotation : declaredAnnotations = annotationType.getDeclaredAnnotations()) {
            if (!GenerateUsing.class.equals(annotation.annotationType())) continue;
            generateUsing = (GenerateUsing)annotation;
            break;
        }
        return generateUsing;
    }

    static Class<? extends GenerationRule> getGeneratorType(Annotation annotation) {
        GenerateUsing generateUsing = Reflector.getGenerateUsingAnnotation(annotation.annotationType());
        return generateUsing.generator();
    }

    static Class<? extends ConversionAdapter> getConversionAdapterType(Field targetField, Class<? extends Annotation> ruleAnnotation) {
        Mapping[] mapping;
        ParameterizedType listType;
        Class<ReferenceRecord> targetFieldType = targetField.getType();
        if (ruleAnnotation == ReferenceRecord.class && targetField.getAnnotation(CustomGenerator.class) != null) {
            String message = String.format("%s and %s can not be set on field %s simultaneously", ReferenceRecord.class.getSimpleName(), CustomGenerator.class.getSimpleName(), targetField.getName());
            throw new RandomDataGeneratorException(message);
        }
        if (ruleAnnotation == ReferenceRecord.class) {
            if (Collection.class.isAssignableFrom(targetFieldType)) {
                listType = (ParameterizedType)targetField.getGenericType();
                targetFieldType = (Class<ReferenceRecord>)((Object)listType.getActualTypeArguments()[0]);
                if (targetFieldType.getAnnotation(ReferencedRecord.class) == null) {
                    String message = String.format("Field %s with annotation %s of type %s must have annotation of %s", targetField.getName(), ReferenceRecord.class.getSimpleName(), targetFieldType.getSimpleName(), ReferencedRecord.class.getSimpleName());
                    throw new RandomDataGeneratorException(message);
                }
            } else if (targetFieldType.getAnnotation(ReferencedRecord.class) == null) {
                String message = String.format("Field %s with annotation %s of type %s must have annotation of %s", targetField.getName(), ReferenceRecord.class.getSimpleName(), targetFieldType.getSimpleName(), ReferencedRecord.class.getSimpleName());
                throw new RandomDataGeneratorException(message);
            }
            targetFieldType = ReferenceRecord.class;
        } else if (Collection.class.isAssignableFrom(targetFieldType)) {
            listType = (ParameterizedType)targetField.getGenericType();
            targetFieldType = (Class)listType.getActualTypeArguments()[0];
            if (targetField.getAnnotation(ReferencedRecord.class) != null) {
                targetFieldType = ReferenceRecord.class;
            }
        } else if (targetFieldType.isArray()) {
            Class<?> componentType = targetFieldType.getComponentType();
            targetFieldType = componentType;
            if (targetField.getAnnotation(ReferencedRecord.class) != null) {
                targetFieldType = ReferenceRecord.class;
            }
        }
        GenerateUsing generateUsing = Reflector.getGenerateUsingAnnotation(ruleAnnotation);
        for (Mapping pair : mapping = generateUsing.mapping()) {
            if (targetFieldType != pair.fieldType()) continue;
            return pair.adapter();
        }
        String message = String.format("Annotation %s not allowed for field %s", ruleAnnotation.getSimpleName(), targetField.getName());
        throw new RuntimeException(message);
    }

    static boolean isValidTargetAnnotatedField(Class<? extends Annotation> annotationType) {
        GenerateUsing annotation = annotationType.getAnnotation(GenerateUsing.class);
        return annotation != null;
    }

    static boolean isCustomGeneratorAnnotatedField(Class<? extends Annotation> annotationType) {
        CustomGenerator annotation = annotationType.getAnnotation(CustomGenerator.class);
        return annotation != null;
    }

    static CustomGenerator getCustomGeneratorAnnotation(Field targetField) {
        CustomGenerator annotation = targetField.getAnnotation(CustomGenerator.class);
        return annotation;
    }

    static CollectionDescriptor getRandomCollectionAnnotation(Field targetField) {
        CollectionDescriptor annotation = targetField.getAnnotation(CollectionDescriptor.class);
        return annotation;
    }

    static GenerationRule getCustomGenerator(CustomGenerator customGeneratorAnnotation, Annotation randomDataTypeAnnotation) {
        Class<? extends GenerationRule> generator = customGeneratorAnnotation.generator();
        Class<? extends GenerationRule> delegate = customGeneratorAnnotation.delegate();
        if (DelegateGenerationRule.class.isAssignableFrom(generator)) {
            if (delegate != InvalidGenerator.class) {
                return Reflector.instantiateDelegateGenerationRule(generator, randomDataTypeAnnotation, delegate);
            }
            String message = String.format("%s can not work with delegate %s to generate data or %s should not extend %s without specifying valid delegate in annotation", generator.getSimpleName(), delegate.getSimpleName(), generator.getSimpleName(), DelegateGenerationRule.class.getSimpleName());
            throw new RandomDataGeneratorException(message);
        }
        return Reflector.instantiateGenerationRule(generator, randomDataTypeAnnotation);
    }

    static GenerationRule instantiateDelegateGenerationRule(Class<? extends GenerationRule> generatorType, Annotation annotation, Class<? extends GenerationRule> delegateGenerator) {
        GenerationRule generationRule = null;
        if (GenerationRule.class.isAssignableFrom(generatorType)) {
            try {
                Constructor<? extends GenerationRule> constructor = generatorType.getDeclaredConstructor(annotation.annotationType(), ProviderFactory.class, GenerationRule.class);
                constructor.setAccessible(true);
                generationRule = constructor.newInstance(annotation, ProviderFactory.getInstance(), Reflector.instantiateGenerationRule(delegateGenerator, annotation));
            }
            catch (NoSuchMethodException e) {
                String message = Reflector.getMissingConstructorErrorMessage(generatorType, annotation.annotationType());
                throw new RuntimeException(message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return generationRule;
    }

    static GenerationRule instantiateGenerationRule(Class<? extends GenerationRule> generatorType, Annotation annotation) {
        GenerationRule generationRule = null;
        if (GenerationRule.class.isAssignableFrom(generatorType)) {
            try {
                Constructor<? extends GenerationRule> constructor = generatorType.getDeclaredConstructor(annotation.annotationType(), ProviderFactory.class);
                constructor.setAccessible(true);
                generationRule = constructor.newInstance(annotation, ProviderFactory.getInstance());
            }
            catch (NoSuchMethodException e) {
                String message = Reflector.getMissingConstructorErrorMessage(generatorType, annotation.annotationType());
                throw new RuntimeException(message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return generationRule;
    }

    public static boolean isReferencedFieldType(Field targetField) {
        ParameterizedType listType;
        Class type;
        return Collection.class.isAssignableFrom(targetField.getType()) && (type = (Class)(listType = (ParameterizedType)targetField.getGenericType()).getActualTypeArguments()[0]).getAnnotation(ReferencedRecord.class) != null;
    }

    static GenerationRule instantiateCollectionGenerationRule(Field targetField, GenerationRule generationRule, ConversionAdapter conversionAdapter) {
        if (Reflector.isReferencedFieldType(targetField)) {
            generationRule = new ReferenceRecordGenerator((ReferenceRecord)generationRule.getAnnotation(), ProviderFactory.getInstance());
        }
        CollectionDescriptor collectionDescriptorAnnotation = Reflector.getRandomCollectionAnnotation(targetField);
        GenerationRule collectionGenerationRule = null;
        if (List.class.isAssignableFrom(targetField.getType())) {
            collectionGenerationRule = new RandomListGenerator(collectionDescriptorAnnotation, ProviderFactory.getInstance(), generationRule, conversionAdapter);
        } else if (targetField.getType().isArray()) {
            collectionGenerationRule = new RandomArrayGenerator(collectionDescriptorAnnotation, ProviderFactory.getInstance(), generationRule, conversionAdapter, targetField.getType().getComponentType());
        }
        return collectionGenerationRule;
    }

    static ConversionAdapter instantiateConversionAdapter(Class<? extends ConversionAdapter> adapter) {
        ConversionAdapter conversionAdapter = null;
        if (ConversionAdapter.class.isAssignableFrom(adapter)) {
            try {
                conversionAdapter = adapter.newInstance();
            }
            catch (InstantiationException e) {
                String message = String.format("%s must have default constructor", adapter.getSimpleName());
                throw new RuntimeException(message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return conversionAdapter;
    }

    private static String getMissingConstructorErrorMessage(Class<? extends GenerationRule> ruleType, Class<? extends Annotation> annotationType) {
        String message = null;
        if (GenerationRule.class.isAssignableFrom(ruleType)) {
            message = String.format("'%s' has invalid number of arguments accepting constructor that accepts a '%s' instance.", ruleType.getName(), annotationType.getName());
        }
        return message;
    }

    public static Class<?> getIfCollectionField(Field field) {
        Class<?> type = field.getType();
        if (Collection.class.isAssignableFrom(type)) {
            return type;
        }
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        return null;
    }

    private Reflector() {
    }
}

