/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer;

import com.infoedge.jrandomizer.Pair;
import com.infoedge.jrandomizer.Reflector;
import com.infoedge.jrandomizer.adapters.ConversionAdapter;
import com.infoedge.jrandomizer.adapters.ObjectToObjectAdapter;
import com.infoedge.jrandomizer.annotations.CustomGenerator;
import com.infoedge.jrandomizer.generators.GenerationRule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Generator<TARGET> {
    private Class<TARGET> mTarget;
    private Map<Field, Pair<GenerationRule, ConversionAdapter>> mFieldRuleMapping = new HashMap<Field, Pair<GenerationRule, ConversionAdapter>>();

    public Generator(Class<TARGET> target) {
        this.mTarget = target;
    }

    public TARGET generate() {
        return this.generate(1).get(0);
    }

    public void generateAsync(OnDataGenerationListener<TARGET> listener) {
        this.generateAsync(1, listener);
    }

    public void generateAsync(int records, OnDataGenerationListener<TARGET> listener) {
        DataGenerationRunnable<TARGET> targetDataGenerationRunnable = new DataGenerationRunnable<TARGET>(listener, records);
        new Thread(targetDataGenerationRunnable).start();
    }

    public List<TARGET> generate(int records) {
        List<Field> targetAnnotatedFields = Reflector.getValidTargetAnnotatedFields(this.mTarget);
        this.createGenerationRules(targetAnnotatedFields);
        ArrayList<Object> randomData = new ArrayList<Object>(records);
        for (int i = 0; i < records; ++i) {
            Object instance = Reflector.createInstance(this.mTarget);
            Set<Field> fields = this.mFieldRuleMapping.keySet();
            for (Field field : fields) {
                Pair<GenerationRule, ConversionAdapter> pair = this.mFieldRuleMapping.get(field);
                GenerationRule generationRule = (GenerationRule)pair.first;
                ConversionAdapter conversionAdapter = (ConversionAdapter)pair.second;
                try {
                    field.setAccessible(true);
                    field.set(instance, conversionAdapter.value(generationRule.generate()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            randomData.add(instance);
        }
        return randomData;
    }

    private Map<Field, Pair<GenerationRule, ConversionAdapter>> createGenerationRules(List<Field> targetAnnotatedFields) {
        LinkedHashMap<Field, Pair<GenerationRule, ConversionAdapter>> generationRules = new LinkedHashMap<Field, Pair<GenerationRule, ConversionAdapter>>();
        for (Field targetAnnotatedField : targetAnnotatedFields) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = targetAnnotatedField.getAnnotations()) {
                if (!Reflector.isValidTargetAnnotatedField(annotation.annotationType())) continue;
                this.mFieldRuleMapping.put(targetAnnotatedField, this.getGenerationRulePair(targetAnnotatedField, annotation));
            }
        }
        return generationRules;
    }

    private Pair<GenerationRule, ConversionAdapter> getGenerationRulePair(Field targetField, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Class<? extends ConversionAdapter> conversionAdapterType = Reflector.getConversionAdapterType(targetField, annotationType);
        ConversionAdapter conversionAdapter = Reflector.instantiateConversionAdapter(conversionAdapterType);
        GenerationRule generationRule = null;
        CustomGenerator customGenerator = Reflector.getCustomGeneratorAnnotation(targetField);
        if (customGenerator != null) {
            generationRule = Reflector.getCustomGenerator(customGenerator, annotation);
        } else {
            Class<? extends GenerationRule> generatorType = Reflector.getGeneratorType(annotation);
            generationRule = Reflector.instantiateGenerationRule(generatorType, annotation);
        }
        if (Reflector.getIfCollectionField(targetField) != null) {
            generationRule = Reflector.instantiateCollectionGenerationRule(targetField, generationRule, conversionAdapter);
            conversionAdapter = (ConversionAdapter)Reflector.createInstance(ObjectToObjectAdapter.class);
        }
        return new Pair<GenerationRule, ConversionAdapter>(generationRule, conversionAdapter);
    }

    private class DataGenerationRunnable<TARGET>
    implements Runnable {
        private OnDataGenerationListener<TARGET> mListener;
        private int records;

        public DataGenerationRunnable(OnDataGenerationListener<TARGET> mListener, int records) {
            this.mListener = mListener;
            this.records = records;
        }

        @Override
        public void run() {
            List randomData = Generator.this.generate(this.records);
            if (this.mListener != null) {
                this.mListener.onDataGenerated(randomData);
            }
        }
    }

    public static interface OnDataGenerationListener<TARGET> {
        public void onDataGenerated(List<TARGET> var1);
    }
}

