/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.installreferrer.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.infoedge.installreferrer.model.UtmSourceInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class ReferralReceiver
extends BroadcastReceiver {
    private static final String PREFS_FILE_NAME = "ReferralParamsFile";
    public static final String[] EXPECTED_PARAMETERS = new String[]{"utm_source", "utm_medium", "utm_term", "utm_content", "utm_campaign"};

    public void onReceive(Context context, Intent intent) {
        HashMap<String, String> referralParams = new HashMap<String, String>();
        if (intent == null) {
            return;
        }
        if (!intent.getAction().equals("com.android.vending.INSTALL_REFERRER")) {
            return;
        }
        String referrer = intent.getStringExtra("referrer");
        if (referrer == null || referrer.length() == 0) {
            return;
        }
        try {
            referrer = URLDecoder.decode(referrer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        try {
            String[] params;
            for (String param : params = referrer.split("&")) {
                String[] pair = param.split("=");
                if (pair.length == 1) {
                    referralParams.put(pair[0], "AndroidApp");
                    continue;
                }
                if (pair.length != 2) continue;
                referralParams.put(pair[0], pair[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ReferralReceiver.storeReferralParams(context, referralParams);
    }

    public static void storeReferralParams(Context context, Map<String, String> params) {
        SharedPreferences storage = context.getSharedPreferences(PREFS_FILE_NAME, 0);
        SharedPreferences.Editor editor = storage.edit();
        for (String key : EXPECTED_PARAMETERS) {
            String value = params.get(key);
            System.out.println("value:::::::::;" + value);
            if (value == null) continue;
            editor.putString(key, value);
        }
        editor.commit();
    }

    public static UtmSourceInfo retrieveReferralParams1(Context context) {
        UtmSourceInfo utmSourceInfo = new UtmSourceInfo();
        SharedPreferences storage = context.getSharedPreferences(PREFS_FILE_NAME, 0);
        utmSourceInfo.setUtmSource(storage.getString(EXPECTED_PARAMETERS[0], null));
        utmSourceInfo.setUtmMedium(storage.getString(EXPECTED_PARAMETERS[1], null));
        utmSourceInfo.setUtmTerm(storage.getString(EXPECTED_PARAMETERS[2], null));
        utmSourceInfo.setUtmContent(storage.getString(EXPECTED_PARAMETERS[3], null));
        utmSourceInfo.setUtmCampaign(storage.getString(EXPECTED_PARAMETERS[4], null));
        return utmSourceInfo;
    }

    public static void clearReferralFile(Context context) {
        try {
            SharedPreferences searcPref = context.getSharedPreferences(PREFS_FILE_NAME, 0);
            SharedPreferences.Editor editor = searcPref.edit();
            editor.clear();
            editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

