/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.service;

import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Logs;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.Run;
import com.influxdb.client.domain.RunManually;
import com.influxdb.client.domain.Runs;
import com.influxdb.client.domain.Task;
import com.influxdb.client.domain.TaskCreateRequest;
import com.influxdb.client.domain.TaskUpdateRequest;
import com.influxdb.client.domain.Tasks;
import java.time.OffsetDateTime;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface TasksService {
    @DELETE(value="api/v2/tasks/{taskID}")
    public Call<Void> deleteTasksID(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @DELETE(value="api/v2/tasks/{taskID}/labels/{labelID}")
    public Call<Void> deleteTasksIDLabelsID(@Path(value="taskID") String var1, @Path(value="labelID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/tasks/{taskID}/members/{userID}")
    public Call<Void> deleteTasksIDMembersID(@Path(value="userID") String var1, @Path(value="taskID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/tasks/{taskID}/owners/{userID}")
    public Call<Void> deleteTasksIDOwnersID(@Path(value="userID") String var1, @Path(value="taskID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/tasks/{taskID}/runs/{runID}")
    public Call<Void> deleteTasksIDRunsID(@Path(value="taskID") String var1, @Path(value="runID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/tasks")
    public Call<Tasks> getTasks(@Header(value="Zap-Trace-Span") String var1, @Query(value="name") String var2, @Query(value="after") String var3, @Query(value="user") String var4, @Query(value="org") String var5, @Query(value="orgID") String var6, @Query(value="status") String var7, @Query(value="limit") Integer var8, @Query(value="type") String var9);

    @GET(value="api/v2/tasks/{taskID}")
    public Call<Task> getTasksID(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/tasks/{taskID}/labels")
    public Call<LabelsResponse> getTasksIDLabels(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/tasks/{taskID}/logs")
    public Call<Logs> getTasksIDLogs(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/tasks/{taskID}/members")
    public Call<ResourceMembers> getTasksIDMembers(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/tasks/{taskID}/owners")
    public Call<ResourceOwners> getTasksIDOwners(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/tasks/{taskID}/runs")
    public Call<Runs> getTasksIDRuns(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2, @Query(value="after") String var3, @Query(value="limit") Integer var4, @Query(value="afterTime") OffsetDateTime var5, @Query(value="beforeTime") OffsetDateTime var6);

    @GET(value="api/v2/tasks/{taskID}/runs/{runID}")
    public Call<Run> getTasksIDRunsID(@Path(value="taskID") String var1, @Path(value="runID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/tasks/{taskID}/runs/{runID}/logs")
    public Call<Logs> getTasksIDRunsIDLogs(@Path(value="taskID") String var1, @Path(value="runID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/tasks/{taskID}")
    public Call<Task> patchTasksID(@Path(value="taskID") String var1, @Body TaskUpdateRequest var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/tasks")
    public Call<Task> postTasks(@Body TaskCreateRequest var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/tasks/{taskID}/labels")
    public Call<LabelResponse> postTasksIDLabels(@Path(value="taskID") String var1, @Body LabelMapping var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/tasks/{taskID}/members")
    public Call<ResourceMember> postTasksIDMembers(@Path(value="taskID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/tasks/{taskID}/owners")
    public Call<ResourceOwner> postTasksIDOwners(@Path(value="taskID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/tasks/{taskID}/runs")
    public Call<Run> postTasksIDRuns(@Path(value="taskID") String var1, @Header(value="Zap-Trace-Span") String var2, @Body RunManually var3);

    @Headers(value={"Content-Type:application/json; charset=utf-8"})
    @POST(value="api/v2/tasks/{taskID}/runs/{runID}/retry")
    public Call<Run> postTasksIDRunsIDRetry(@Path(value="taskID") String var1, @Path(value="runID") String var2, @Header(value="Zap-Trace-Span") String var3, @Body String var4);
}

