/*
 * Decompiled with CFR 0.152.
 */
package com.inflectra.spiratest.plugins;

import com.inflectra.spiratest.plugins.SpiraBuilder;
import com.inflectra.spiratest.plugins.SpiraImportExport;
import hudson.Extension;
import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.List;
import java.util.regex.Pattern;

@Extension
public class SpiraChangeLogAnnotator
extends ChangeLogAnnotator {
    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        int projectId = 0;
        Project project = (Project)build.getProject();
        SpiraBuilder spiraBuilder = (SpiraBuilder)((Object)project.getBuildWrappers().get(Descriptor.find((String)SpiraBuilder.class.getName())));
        String url = spiraBuilder.getDescriptor().getUrl();
        String username = spiraBuilder.getDescriptor().getUsername();
        String password = spiraBuilder.getDescriptor().getPassword();
        String projectIdString = spiraBuilder.getProject();
        try {
            projectId = Integer.parseInt(projectIdString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        SpiraImportExport spiraClient = new SpiraImportExport();
        spiraClient.setUrl(url);
        spiraClient.setUserName(username);
        spiraClient.setPassword(password);
        spiraClient.setProjectId(projectId);
        Pattern regex = Pattern.compile("\\[([A-Z]{2,}):([0-9]+)\\]");
        List tokens = text.findTokens(regex);
        for (MarkupText.SubText token : tokens) {
            if (token.groupCount() <= 1) continue;
            String prefix = token.group(1);
            try {
                int artifactId = Integer.parseInt(token.group(2));
                String artifactUrl = spiraClient.createArtifactUrl(prefix, artifactId);
                String startTag = "<a href=\"" + artifactUrl + "\">";
                String endTag = "</a>";
                token.surroundWith(startTag, endTag);
            }
            catch (NumberFormatException ex) {
                int i = 0;
                ++i;
            }
            catch (Exception ex) {
                int i = 0;
                ++i;
            }
        }
    }
}

