/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.learner;

import com.indeed.vw.wrapper.jni.NativeUtils;
import com.indeed.vw.wrapper.learner.VWFloatArrayLearner;
import com.indeed.vw.wrapper.learner.VWFloatLearner;
import com.indeed.vw.wrapper.learner.VWIntArrayLearner;
import com.indeed.vw.wrapper.learner.VWIntLearner;
import com.indeed.vw.wrapper.learner.VWLearner;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class VWLearners {
    private static volatile boolean loadedNativeLibrary = false;
    private static final Lock STATIC_LOCK = new ReentrantLock();

    private VWLearners() {
    }

    public static <T extends VWLearner> T create(List<String> args) {
        long nativePointer = VWLearners.initializeVWJni(args);
        return VWLearners.create(nativePointer, "Unknown VW return type using arguments: " + args);
    }

    public static <T extends VWLearner> T create(String command) {
        long nativePointer = VWLearners.initializeVWJni(command);
        return VWLearners.create(nativePointer, "Unknown VW return type using command: " + command);
    }

    private static <T extends VWLearner> T create(long nativePointer, String exceptionMessage) {
        VWReturnType returnType = VWLearners.getReturnType(nativePointer);
        switch (returnType) {
            case VWFloatType: {
                return (T)new VWFloatLearner(nativePointer);
            }
            case VWIntType: {
                return (T)new VWIntLearner(nativePointer);
            }
            case VWFloatArrayType: {
                return (T)new VWFloatArrayLearner(nativePointer);
            }
            case VWIntArrayType: {
                return (T)new VWIntArrayLearner(nativePointer);
            }
        }
        VWLearners.closeInstance(nativePointer);
        throw new IllegalArgumentException(exceptionMessage);
    }

    private static long initializeVWJni(String command) {
        long nativePointer;
        try {
            nativePointer = VWLearners.initialize(command);
            loadedNativeLibrary = true;
        }
        catch (UnsatisfiedLinkError e) {
            VWLearners.loadNativeLibrary();
            nativePointer = VWLearners.initialize(command);
        }
        return nativePointer;
    }

    private static long initializeVWJni(List<String> args) {
        long nativePointer;
        try {
            nativePointer = VWLearners.initialize(args.toArray(new String[0]));
            loadedNativeLibrary = true;
        }
        catch (UnsatisfiedLinkError e) {
            VWLearners.loadNativeLibrary();
            nativePointer = VWLearners.initialize(args.toArray(new String[0]));
        }
        return nativePointer;
    }

    private static void loadNativeLibrary() {
        if (!loadedNativeLibrary) {
            STATIC_LOCK.lock();
            try {
                if (!loadedNativeLibrary) {
                    NativeUtils.loadOSDependentLibrary("/lib/vw_jni", ".lib");
                    loadedNativeLibrary = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                STATIC_LOCK.unlock();
            }
        }
    }

    private static native long initialize(String var0);

    private static native long initialize(String[] var0);

    private static native VWReturnType getReturnType(long var0);

    static native void closeInstance(long var0);

    static enum VWReturnType {
        Unknown,
        VWFloatType,
        VWIntType,
        VWIntArrayType,
        VWFloatArrayType;

    }
}

