/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.progvalidation;

import com.indeed.vw.wrapper.progvalidation.PrecisionValidation;
import com.indeed.vw.wrapper.progvalidation.ProgressiveValidation;
import com.indeed.vw.wrapper.progvalidation.RecallValidation;

public class FOneScoreValidation
extends ProgressiveValidation {
    private final PrecisionValidation precision;
    private final RecallValidation recall;

    public FOneScoreValidation(double decisionThreashold) {
        super("F1-SCORE", true);
        this.precision = new PrecisionValidation(decisionThreashold);
        this.recall = new RecallValidation(decisionThreashold);
    }

    @Override
    public synchronized double getScore() {
        if (this.precision.getScore() == 0.0 || this.recall.getScore() == 0.0) {
            return 0.0;
        }
        return 2.0 * this.precision.getScore() * this.recall.getScore() / (this.precision.getScore() + this.recall.getScore());
    }

    @Override
    public synchronized void updateScore(double prediction, double actual) {
        this.precision.updateScore(prediction, actual);
        this.recall.updateScore(prediction, actual);
    }
}

