/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.varexport;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.escape.Escaper;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class Variable<T> {
    private static Set<Character> nameValueSpecialCharacters = ImmutableSet.of((Object)Character.valueOf(':'), (Object)Character.valueOf('='));
    private static Pattern INDEXABLE_SPLITTER = Pattern.compile("[^a-z0-9]+");
    private final String name;
    private final String[] indexableNames;
    private final String doc;
    private final String namespace;
    private final boolean expand;
    private final Set<String> tags;

    private static String[] buildIndexableName(String name) {
        if (name == null) {
            return new String[0];
        }
        return INDEXABLE_SPLITTER.split(name.toLowerCase());
    }

    public Variable(String name, Set<String> tags, String doc, boolean expand, String namespace) {
        this.name = name;
        this.indexableNames = Variable.buildIndexableName(name);
        this.tags = tags;
        this.doc = doc;
        this.expand = expand;
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public String[] getIndexableNames() {
        return this.indexableNames;
    }

    public String getDoc() {
        return this.doc != null ? this.doc : "";
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Long getLastUpdated() {
        return null;
    }

    public boolean isExpandable() {
        return this.expand && this.canExpand();
    }

    public Map<?, ?> expand() {
        if (!this.isExpandable()) {
            throw new RuntimeException(this.name + " is not expandable");
        }
        return (Map)this.getValue();
    }

    public boolean hasDoc() {
        return !Strings.isNullOrEmpty((String)this.getDoc());
    }

    protected abstract boolean isLive();

    protected abstract boolean canExpand();

    public abstract T getValue();

    public String getNamespaceAndName() {
        if (Strings.isNullOrEmpty((String)this.namespace)) {
            return this.name;
        }
        return this.namespace + "-" + this.name;
    }

    public void write(PrintWriter out, boolean includeDoc) {
        T localValue = this.getValue();
        if (includeDoc) {
            out.println();
            Long lastUpdate = this.getLastUpdated();
            if (this.hasDoc() || lastUpdate != null) {
                out.print("# ");
                if (this.hasDoc()) {
                    out.print(Variable.makePropertiesSafe(this.getDoc(), null));
                }
                if (lastUpdate != null) {
                    out.print(" (last update: " + lastUpdate + ")");
                }
                out.println();
            }
        }
        out.println(this.toString());
    }

    public void writeValue(PrintWriter out) {
        out.print(Variable.makePropertiesSafe(this.getValue(), nameValueSpecialCharacters));
    }

    public String getValueString() {
        T value = this.getValue();
        return "" + value;
    }

    public String getSafeValue() {
        return Variable.makePropertiesSafe(this.getValue(), nameValueSpecialCharacters);
    }

    public String getSafeName() {
        return Variable.makePropertiesSafe(this.name, nameValueSpecialCharacters);
    }

    public String toString() {
        return this.getSafeName() + "=" + this.getSafeValue();
    }

    private static String makePropertiesSafe(Object in, Set<Character> toEscape) {
        if (in == null) {
            return "null";
        }
        String str = in.toString();
        StringBuilder result = null;
        for (int i = 0; i < str.length(); ++i) {
            boolean requiresEscape;
            char c = str.charAt(i);
            boolean isAscii = CharMatcher.ASCII.matches(c);
            boolean bl = requiresEscape = !isAscii || toEscape != null && toEscape.contains(Character.valueOf(c));
            if (requiresEscape && result == null) {
                result = new StringBuilder(str.length() * 2);
                result.append(str, 0, i);
            }
            if (!isAscii) {
                result.append(JavaSourceEscaper.escapeChar(c));
                continue;
            }
            if (requiresEscape) {
                result.append('\\');
            }
            if (result == null) continue;
            result.append(c);
        }
        return result == null ? str : result.toString();
    }

    private static class JavaSourceEscaper
    extends Escaper {
        private JavaSourceEscaper() {
        }

        public String escape(String input) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (!CharMatcher.ASCII.matches(c)) {
                    b.append(JavaSourceEscaper.escapeChar(c));
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }

        public static String escapeChar(char c) {
            if (c < '\u0010') {
                return "\\u000" + Integer.toHexString(c);
            }
            if (c < '\u0100') {
                return "\\u00" + Integer.toHexString(c);
            }
            if (c < '\u1000') {
                return "\\u0" + Integer.toHexString(c);
            }
            return "\\u" + Integer.toHexString(c);
        }
    }
}

