/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.varexport.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import com.indeed.util.varexport.VarExporter;
import com.indeed.util.varexport.Variable;
import com.indeed.util.varexport.VariableHost;
import com.indeed.util.varexport.VariableVisitor;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ViewExportedVariablesServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(ViewExportedVariablesServlet.class);
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private Template varTextTemplate;
    private Template varHtmlTemplate;
    private Template browseNamespaceTemplate;

    @VisibleForTesting
    protected void setVarTextTemplate(Template varTextTemplate) {
        this.varTextTemplate = varTextTemplate;
    }

    @VisibleForTesting
    protected void setVarHtmlTemplate(Template varHtmlTemplate) {
        this.varHtmlTemplate = varHtmlTemplate;
    }

    @VisibleForTesting
    protected void setBrowseNamespaceTemplate(Template browseNamespaceTemplate) {
        this.browseNamespaceTemplate = browseNamespaceTemplate;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Configuration config = new Configuration();
        config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        String templateLoadPath = servletConfig.getInitParameter("templateLoadPath");
        if (templateLoadPath != null && new File(templateLoadPath).isDirectory()) {
            try {
                config.setDirectoryForTemplateLoading(new File(templateLoadPath));
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            String contextLoadPath = servletConfig.getInitParameter("contextLoadPath");
            if (contextLoadPath != null) {
                ServletContext ctx = servletConfig.getServletContext();
                config.setServletContextForTemplateLoading((Object)ctx, contextLoadPath);
            } else {
                config.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "/");
            }
        }
        try {
            this.varTextTemplate = config.getTemplate("vars-text.ftl");
            this.varHtmlTemplate = config.getTemplate("vars-html.ftl");
            this.browseNamespaceTemplate = config.getTemplate("browsens.ftl");
        }
        catch (IOException e) {
            throw new ServletException("Failed to load template", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        if ("1".equals(request.getParameter("browse"))) {
            this.showNamespaces(request.getRequestURI(), response);
        } else {
            String[] vars = request.getParameterValues("v");
            boolean doc = "1".equals(request.getParameter("doc"));
            String fmtParam = request.getParameter("fmt");
            DisplayType displayType = "html".equals(fmtParam) ? DisplayType.HTML : ("json".equals(fmtParam) ? DisplayType.JSON : DisplayType.PLAINTEXT);
            this.showVariables(request.getRequestURI(), response, request.getParameter("ns"), request.getParameter("tag"), doc, displayType, vars);
        }
    }

    private void showNamespaces(String uri, HttpServletResponse response) throws IOException {
        List<String> namespaces = VarExporter.getNamespaces();
        namespaces.remove(null);
        Collections.sort(namespaces);
        HashMap parents = Maps.newHashMapWithExpectedSize((int)namespaces.size());
        for (String namespace : namespaces) {
            VarExporter parent = VarExporter.forNamespace(namespace).getParentNamespace();
            if (parent == null) {
                parents.put(namespace, "none");
                continue;
            }
            parents.put(namespace, parent.getNamespace());
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("urlPath", uri);
        root.put("namespaces", namespaces);
        root.put("parents", parents);
        try {
            this.browseNamespaceTemplate.process(root, (Writer)out);
        }
        catch (Exception e) {
            throw new IOException("template failure", e);
        }
        out.flush();
        out.close();
    }

    @Deprecated
    protected void showVariables(String uri, HttpServletResponse response, String namespace, boolean includeDoc, boolean html, String ... vars) throws IOException {
        DisplayType displayType = html ? DisplayType.HTML : DisplayType.PLAINTEXT;
        this.showVariables(uri, response, namespace, includeDoc, displayType, vars);
    }

    @Deprecated
    protected void showVariables(String uri, HttpServletResponse response, String namespace, boolean includeDoc, DisplayType displayType, String ... vars) throws IOException {
        this.showVariables(uri, response, namespace, null, includeDoc, displayType, vars);
    }

    protected void showVariables(String uri, HttpServletResponse response, String namespace, String tag, boolean includeDoc, DisplayType displayType, String ... vars) throws IOException {
        VariableHost exporter = !Strings.isNullOrEmpty((String)tag) ? VarExporter.withTag(tag) : (!Strings.isNullOrEmpty((String)namespace) ? VarExporter.forNamespace(namespace) : VarExporter.global());
        PrintWriter out = response.getWriter();
        response.setContentType(displayType.mimeType);
        switch (displayType) {
            case HTML: {
                this.showUsingTemplate(exporter, uri, namespace, includeDoc, this.varHtmlTemplate, true, out, vars);
                break;
            }
            case PLAINTEXT: {
                this.showUsingTemplate(exporter, uri, namespace, includeDoc, this.varTextTemplate, false, out, vars);
            }
        }
        out.flush();
        out.close();
    }

    private void showUsingTemplate(VariableHost exporter, String uri, String namespace, boolean includeDoc, Template template, boolean withIndex, PrintWriter out, String ... vars) throws IOException {
        ArrayList varList;
        String name = namespace == null ? "Global" : namespace;
        HashMap<String, Object> root = new HashMap<String, Object>();
        DateFormat df = SimpleDateFormat.getDateTimeInstance();
        root.put("urlPath", uri);
        root.put("name", name);
        root.put("date", df.format(new Date()));
        root.put("includeDoc", includeDoc);
        if (vars != null && vars.length == 1) {
            Variable v = exporter.getVariable(vars[0]);
            if (v != null) {
                varList = Lists.newArrayListWithExpectedSize((int)1);
                this.addVariable(v, varList);
            } else {
                varList = ImmutableList.of();
            }
        } else {
            varList = Lists.newArrayListWithExpectedSize((int)(vars != null ? vars.length : 256));
            if (vars == null || vars.length == 0) {
                exporter.visitVariables(new VariableVisitor(){

                    @Override
                    public void visit(Variable var) {
                        ViewExportedVariablesServlet.this.addVariable(var, varList);
                    }
                });
            } else {
                for (String var : vars) {
                    Variable v = exporter.getVariable(var);
                    if (v == null) continue;
                    this.addVariable(v, varList);
                }
            }
        }
        root.put("vars", varList);
        if (withIndex) {
            String varsIndex = this.buildIndex(varList);
            root.put("varsIndex", varsIndex);
        }
        try {
            template.process(root, (Writer)out);
        }
        catch (Exception e) {
            throw new IOException("template failure", e);
        }
    }

    private String buildIndex(List<Variable> varList) {
        SetMultimap<String, Integer> uniGram = this.buildNGramIndex(varList, 1);
        SetMultimap<String, Integer> biGram = this.buildNGramIndex(varList, 2);
        SetMultimap<String, Integer> triGram = this.buildNGramIndex(varList, 3);
        StringBuilder json = new StringBuilder();
        json.append('{').append('\n');
        json.append("\"uniGram\":").append('\n');
        this.appendTo(json, uniGram).append(',').append('\n');
        json.append("\"biGram\":").append('\n');
        this.appendTo(json, biGram).append(',').append('\n');
        json.append("\"triGram\":").append('\n');
        this.appendTo(json, triGram);
        json.append('}');
        return json.toString();
    }

    private <K> StringBuilder appendTo(StringBuilder json, SetMultimap<K, Integer> map) {
        json.append('{').append('\n');
        boolean isFirst = true;
        for (Object key : map.keySet()) {
            Set values = map.get(key);
            if (isFirst) {
                isFirst = false;
            } else {
                json.append(',').append('\n');
            }
            json.append('\"').append(key.toString()).append('\"').append(':');
            json.append('[');
            COMMA_JOINER.appendTo(json, (Iterable)values);
            json.append(']');
        }
        json.append('\n').append('}');
        return json;
    }

    private SetMultimap<String, Integer> buildNGramIndex(List<Variable> varList, int n) {
        TreeMultimap uniGram = TreeMultimap.create();
        for (int index = 0; index < varList.size(); ++index) {
            String[] indexableNames;
            Variable var = varList.get(index);
            for (String indexableName : indexableNames = var.getIndexableNames()) {
                for (int i = 0; i < indexableName.length() - n + 1; ++i) {
                    String key = indexableName.substring(i, i + n);
                    uniGram.put((Object)key, (Object)index);
                }
            }
        }
        return uniGram;
    }

    private void addVariable(Variable v, List<Variable> out) {
        try {
            v.toString();
            out.add(v);
        }
        catch (Throwable t) {
            log.warn((Object)("Cannot resolve variable " + v.getName()), t);
        }
    }

    public static enum DisplayType {
        PLAINTEXT("text", "text/plain"),
        JSON("json", "application/json"),
        HTML("html", "text/html");

        private final String paramValue;
        private final String mimeType;

        private DisplayType(String paramValue, String mimeType) {
            this.paramValue = paramValue;
            this.mimeType = mimeType;
        }
    }
}

