/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.varexport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.indeed.util.varexport.Variable;
import java.util.Map;
import java.util.Set;

public class ManagedVariable<T>
extends Variable<T> {
    @VisibleForTesting
    protected Supplier<Long> clock = new Supplier<Long>(){

        public Long get() {
            return System.currentTimeMillis();
        }
    };
    private T value;
    private Long lastUpdated = (Long)this.clock.get();

    public static <T> Builder<T> builder() {
        return new Builder("");
    }

    public static <T> Builder<T> builder(String namespace) {
        return new Builder(namespace);
    }

    private ManagedVariable(String name, Set<String> tags, String doc, boolean expand, T value, String namespace) {
        super(name, tags, doc, expand, namespace);
        this.value = value;
    }

    public void set(T value) {
        this.value = value;
        this.lastUpdated = (Long)this.clock.get();
    }

    @Override
    protected boolean isLive() {
        return true;
    }

    @Override
    protected boolean canExpand() {
        return this.value != null && Map.class.isAssignableFrom(this.value.getClass());
    }

    @Override
    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public static class Builder<T> {
        private final String namespace;
        private String name = null;
        private String doc = "";
        private boolean expand = false;
        private Set<String> tags = ImmutableSet.of();
        private T value = null;

        private Builder(String namespace) {
            this.namespace = namespace;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setDoc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder<T> setExpand(boolean expand) {
            this.expand = expand;
            return this;
        }

        public Builder<T> setValue(T value) {
            this.value = value;
            return this;
        }

        public Builder<T> setTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public ManagedVariable<T> build() {
            if (this.name == null) {
                throw new RuntimeException("name must not be null for ManagedVariable");
            }
            if (this.tags == null) {
                throw new RuntimeException("tags must not be null for ManagedVariable");
            }
            return new ManagedVariable(this.name, this.tags, this.doc, this.expand, this.value, this.namespace);
        }
    }
}

