/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.urlparsing;

public final class ParseUtils {
    private static final char[] infinityChars = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    private static final char[] naNChars = new char[]{'N', 'a', 'N'};
    public static final char INVALID_HEX = '\u0100';

    public static int parseInt(String s, int start, int end) throws NumberFormatException {
        return ParseUtils.parseSignedInt(s, start, end);
    }

    public static int parseSignedInt(CharSequence s, int start, int end) throws NumberFormatException {
        if (s.charAt(start) == '-') {
            return -ParseUtils.parseUnsignedInt(s, start + 1, end);
        }
        return ParseUtils.parseUnsignedInt(s, start, end);
    }

    public static int parseUnsignedInt(CharSequence s, int start, int end) throws NumberFormatException {
        int ret = 0;
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                throw new NumberFormatException("Not a valid base-10 digit: " + c + " in " + s.subSequence(start, end));
            }
            int val = c - 48;
            ret = ret * 10 + val;
        }
        return ret;
    }

    public static long parseSignedLong(CharSequence s, int start, int end) throws NumberFormatException {
        if (s.charAt(start) == '-') {
            return -ParseUtils.parseUnsignedLong(s, start + 1, end);
        }
        return ParseUtils.parseUnsignedLong(s, start, end);
    }

    public static long parseUnsignedLong(CharSequence s, int start, int end) throws NumberFormatException {
        long ret = 0L;
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                throw new NumberFormatException("Not a valid base-10 digit: " + c + " in " + s.subSequence(start, end));
            }
            int val = c - 48;
            ret = ret * 10L + (long)val;
        }
        return ret;
    }

    public static float parseFloat(String s, int start, int end) throws NumberFormatException {
        int sign;
        int i = start;
        if (s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else {
            sign = 1;
        }
        double ret = 0.0;
        boolean decimalFound = false;
        double mult = 1.0;
        boolean isScientificNotation = false;
        while (i < end) {
            char c = s.charAt(i);
            if (c == 'E' || c == 'e') {
                isScientificNotation = true;
                break;
            }
            if (c == 'N' || c == 'I') {
                int j;
                boolean isNanStart = c == 'N';
                char[] charsToMatch = c == 'N' ? naNChars : infinityChars;
                for (j = 0; i < end && j < charsToMatch.length; ++i, ++j) {
                    if (s.charAt(i) == charsToMatch[j]) {
                        continue;
                    }
                    throw new NumberFormatException("Unsupported format, unable to parse input string ");
                }
                if (i == end && j == charsToMatch.length) {
                    if (isNanStart) {
                        return Float.NaN;
                    }
                    if (sign == 1) {
                        return Float.POSITIVE_INFINITY;
                    }
                    return Float.NEGATIVE_INFINITY;
                }
                throw new NumberFormatException("Unsupported format, unable to parse input string ");
            }
            if (decimalFound) {
                mult *= 10.0;
            }
            if (c >= '0' && c <= '9') {
                int val = c - 48;
                ret = ret * 10.0 + (double)val;
            } else if (c == '.') {
                decimalFound = true;
            } else {
                throw new NumberFormatException("Not a valid base-10 digit: " + c + " in " + s.substring(start, end));
            }
            ++i;
        }
        ret /= mult;
        if (isScientificNotation) {
            int exponent = ParseUtils.parseSignedInt(s, ++i, end);
            ret *= Math.pow(10.0, exponent);
        }
        return (float)(ret * (double)sign);
    }

    public static long parseTimestampFromUIDString(String s, int start, int end) {
        long ret = 0L;
        for (int i = start; i < end && i < start + 9; ++i) {
            ret <<= 5;
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ret |= (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'v') {
                ret |= (long)(c - 97 + 10);
                continue;
            }
            if (c >= 'A' && c <= 'V') {
                ret |= (long)(c - 65 + 10);
                continue;
            }
            throw new IllegalArgumentException(s.substring(start, end) + " is not a valid UID!");
        }
        return ret;
    }

    public static void urlDecodeInplace(StringBuilder input) {
        ParseUtils.urlDecodeInto(input, 0, input.length(), input, true);
    }

    public static void urlDecodeInto(CharSequence input, int start, int end, StringBuilder result) {
        ParseUtils.urlDecodeInto(input, start, end, result, false);
    }

    private static void urlDecodeInto(CharSequence input, int start, int end, StringBuilder result, boolean inplace) {
        int writeHead = start;
        for (int i = start; i < end; ++i) {
            char c = input.charAt(i);
            if (c == '%' && i + 2 < end) {
                char val3;
                char val2;
                char val = ParseUtils.decodeHexPair(input.charAt(i + 1), input.charAt(i + 2));
                if ((val & 0xE0) == 192) {
                    if (i + 5 < end && input.charAt(i + 3) == '%' && (val2 = ParseUtils.decodeHexPair(input.charAt(i + 4), input.charAt(i + 5))) != '\u0100' && (val2 & 0xC0) == 128) {
                        c = (char)((val & 0x1F) << 6 | val2 & 0x3F);
                        i += 5;
                    }
                } else if ((val & 0xF0) == 224) {
                    if (i + 8 < end && input.charAt(i + 3) == '%' && input.charAt(i + 6) == '%') {
                        val2 = ParseUtils.decodeHexPair(input.charAt(i + 4), input.charAt(i + 5));
                        val3 = ParseUtils.decodeHexPair(input.charAt(i + 7), input.charAt(i + 8));
                        if (val2 != '\u0100' && val3 != '\u0100' && (val2 & 0xC0) == 128 && (val3 & 0xC0) == 128) {
                            c = (char)((val & 0xF) << 12 | (val2 & 0x3F) << 6 | val3 & 0x3F);
                            i += 8;
                        }
                    }
                } else if ((val & 0xF8) == 240) {
                    if (i + 11 < end && input.charAt(i + 3) == '%' && input.charAt(i + 6) == '%' && input.charAt(i + 9) == '%') {
                        val2 = ParseUtils.decodeHexPair(input.charAt(i + 4), input.charAt(i + 5));
                        val3 = ParseUtils.decodeHexPair(input.charAt(i + 7), input.charAt(i + 8));
                        char val4 = ParseUtils.decodeHexPair(input.charAt(i + 10), input.charAt(i + 11));
                        if (val2 != '\u0100' && val3 != '\u0100' && val4 != '\u0100' && (val2 & 0xC0) == 128 && (val3 & 0xC0) == 128 && (val4 & 0xC0) == 128) {
                            int codePoint = (val & 0xF) << 15 | (val2 & 0x3F) << 12 | (val3 & 0x3F) << 6 | val4 & 0x3F;
                            if (codePoint < 65536) {
                                c = (char)codePoint;
                            } else {
                                int offset = codePoint - 65536;
                                char highChar = (char)((offset >>> 10) + 55296);
                                char lowChar = (char)((offset & 0x3FF) + 56320);
                                if (!inplace) {
                                    result.append(highChar);
                                } else {
                                    result.setCharAt(writeHead++, highChar);
                                }
                                c = lowChar;
                            }
                            i += 11;
                        }
                    }
                } else if (val != '\u0100') {
                    c = val;
                    i += 2;
                }
            } else if (c == '+') {
                c = ' ';
            }
            if (!inplace) {
                result.append(c);
                continue;
            }
            result.setCharAt(writeHead++, c);
        }
        if (inplace) {
            result.delete(writeHead, end);
        }
    }

    public static char decodeHexPair(char c1, char c2) {
        char ret = '\u0000';
        if (c1 >= '0' && c1 <= '9') {
            ret = (char)(ret | c1 - 48);
        } else if (c1 >= 'a' && c1 <= 'f') {
            ret = (char)(ret | c1 - 97 + 10);
        } else if (c1 >= 'A' && c1 <= 'F') {
            ret = (char)(ret | c1 - 65 + 10);
        } else {
            return '\u0100';
        }
        ret = (char)(ret << 4);
        if (c2 >= '0' && c2 <= '9') {
            ret = (char)(ret | c2 - 48);
        } else if (c2 >= 'a' && c2 <= 'f') {
            ret = (char)(ret | c2 - 97 + 10);
        } else if (c2 >= 'A' && c2 <= 'F') {
            ret = (char)(ret | c2 - 65 + 10);
        } else {
            return '\u0100';
        }
        return ret;
    }
}

