/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.urlparsing;

import com.indeed.util.urlparsing.QueryStringParserCallback;

public class QueryStringParser {
    public static <T> void parseQueryString(String queryString, QueryStringParserCallback<T> callback, T storage) {
        QueryStringParser.parseQueryString(queryString, callback, storage, 0, queryString.length(), "&", "=");
    }

    public static <T> void parseQueryString(String queryString, QueryStringParserCallback<T> callback, T storage, int qsStart, int qsEnd, String pairDelim, String kvDelim) {
        int kvPairStart = qsStart;
        while (kvPairStart <= qsEnd) {
            int equalPos;
            int kvPairEnd = queryString.indexOf(pairDelim, kvPairStart);
            if (kvPairEnd < 0 || kvPairEnd > qsEnd) {
                kvPairEnd = qsEnd;
            }
            if ((equalPos = queryString.indexOf(kvDelim, kvPairStart)) < 0 || equalPos > kvPairEnd) {
                callback.parseKeyValuePair(queryString, kvPairStart, kvPairEnd, kvPairEnd, kvPairEnd, storage);
            } else {
                callback.parseKeyValuePair(queryString, kvPairStart, equalPos, equalPos + kvDelim.length(), kvPairEnd, storage);
            }
            kvPairStart = kvPairEnd + pairDelim.length();
        }
    }
}

