/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.map;

import com.google.common.base.Supplier;
import com.indeed.util.serialization.CollectionSuppliers;
import com.indeed.util.serialization.Serializer;
import com.indeed.util.serialization.map.MapSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NavigableMapSerializer<K, V>
implements Serializer<NavigableMap<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(NavigableMapSerializer.class);
    private final MapSerializer<K, V> mapSerializer;

    public static <K extends Comparable, V> NavigableMapSerializer<K, V> treeMapSerializer(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new NavigableMapSerializer<K, V>(new CollectionSuppliers.TreeMapSupplier(), keySerializer, valueSerializer);
    }

    public NavigableMapSerializer(Supplier<? extends NavigableMap<K, V>> mapSupplier, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.mapSerializer = new MapSerializer<K, V>(mapSupplier, keySerializer, valueSerializer);
    }

    @Override
    public void write(NavigableMap<K, V> map, DataOutput out) throws IOException {
        this.mapSerializer.write(map, out);
    }

    @Override
    public NavigableMap<K, V> read(DataInput in) throws IOException {
        return (NavigableMap)this.mapSerializer.read(in);
    }
}

