/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.array;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.indeed.util.serialization.Stringifier;
import com.indeed.util.serialization.splitter.EscapeAwareSplitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntArrayStringifier
implements Stringifier<int[]> {
    private static final Logger log = LoggerFactory.getLogger(IntArrayStringifier.class);

    @Override
    public String toString(int[] ints) {
        return Arrays.toString(ints);
    }

    @Override
    public int[] fromString(String str) {
        ArrayList ints = Lists.newArrayList();
        EscapeAwareSplitter splitter = new EscapeAwareSplitter(CharMatcher.whitespace().or(CharMatcher.is((char)',')), EscapeAwareSplitter.NO_ESCAPE_LEXER_SUPPLIER);
        Iterator<String> split = splitter.split(str.substring(1, str.length() - 1));
        while (split.hasNext()) {
            ints.add(Integer.parseInt(split.next()));
        }
        int[] ret = new int[ints.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)ints.get(i);
        }
        return ret;
    }
}

