/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.HeapDataAccess;
import com.indeed.util.unsafe.IndeedUnsafe;

final class NativeEndianHeapDataAccess
implements HeapDataAccess {
    private static final NativeEndianHeapDataAccess instance = new NativeEndianHeapDataAccess();

    public static NativeEndianHeapDataAccess getInstance() {
        return instance;
    }

    private NativeEndianHeapDataAccess() {
    }

    @Override
    public char getChar(byte[] b, int off) {
        return IndeedUnsafe.getChar((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off));
    }

    @Override
    public short getShort(byte[] b, int off) {
        return IndeedUnsafe.getShort((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off));
    }

    @Override
    public int getInt(byte[] b, int off) {
        return IndeedUnsafe.getInt((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off));
    }

    @Override
    public float getFloat(byte[] b, int off) {
        return IndeedUnsafe.getFloat((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off));
    }

    @Override
    public long getLong(byte[] b, int off) {
        return IndeedUnsafe.getLong((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off));
    }

    @Override
    public double getDouble(byte[] b, int off) {
        return IndeedUnsafe.getDouble((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off));
    }

    @Override
    public void putChar(byte[] b, int off, char val) {
        IndeedUnsafe.putChar((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off), (char)val);
    }

    @Override
    public void putShort(byte[] b, int off, short val) {
        IndeedUnsafe.putShort((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off), (short)val);
    }

    @Override
    public void putInt(byte[] b, int off, int val) {
        IndeedUnsafe.putInt((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off), (int)val);
    }

    @Override
    public void putFloat(byte[] b, int off, float val) {
        IndeedUnsafe.putFloat((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off), (float)val);
    }

    @Override
    public void putLong(byte[] b, int off, long val) {
        IndeedUnsafe.putLong((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off), (long)val);
    }

    @Override
    public void putDouble(byte[] b, int off, double val) {
        IndeedUnsafe.putDouble((Object)b, (long)(IndeedUnsafe.BYTE_ARRAY_BASE_OFFSET + (long)off), (double)val);
    }
}

