/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LongArray {
    private static final Logger log = LoggerFactory.getLogger(LongArray.class);
    private static final long TYPE_SIZE = 8L;
    private final Memory buffer;
    private final long length;

    public LongArray(Memory buffer, long address, long length) {
        if (address < 0L) {
            throw new IndexOutOfBoundsException("address must be >= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (address + length * 8L > buffer.length()) {
            throw new IndexOutOfBoundsException(String.format("address+length*%d must be <= buffer.length()", 8L));
        }
        this.buffer = buffer.slice(address, length * 8L);
        this.length = length;
    }

    public long get(long index) {
        return this.buffer.getLong(index * 8L);
    }

    public void get(long index, long[] longs, int start, int length) {
        for (int i = 0; i < length; ++i) {
            longs[start + i] = this.buffer.getLong((index + (long)i) * 8L);
        }
    }

    public void get(long index, long[] longs) {
        this.get(index, longs, 0, longs.length);
    }

    public void get(long index, LongArray longs, long start, long length) {
        longs.set(start, this, index, length);
    }

    public void get(long index, LongArray longs) {
        this.get(index, longs, 0L, longs.length);
    }

    public void set(long index, long value) {
        this.buffer.putLong(index * 8L, value);
    }

    public void set(long index, long[] longs, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.putLong((index + (long)i) * 8L, longs[start + i]);
        }
    }

    public void set(long index, long[] longs) {
        this.set(index, longs, 0, longs.length);
    }

    public void set(long index, LongArray longs, long start, long length) {
        longs.buffer.getBytes(index * 8L, this.buffer, start * 8L, length * 8L);
    }

    public void set(long index, LongArray longs) {
        this.set(index, longs, 0L, longs.length);
    }

    public long length() {
        return this.length;
    }

    public LongArray slice(long start, long length) {
        return new LongArray(this.buffer, start * 8L, length);
    }
}

