/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntArray {
    private static final Logger log = LoggerFactory.getLogger(IntArray.class);
    private static final long TYPE_SIZE = 4L;
    private final Memory buffer;
    private final long length;

    public IntArray(Memory buffer, long address, long length) {
        if (address < 0L) {
            throw new IndexOutOfBoundsException("address must be >= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (address + length * 4L > buffer.length()) {
            throw new IndexOutOfBoundsException(String.format("address+length*%d must be <= buffer.length()", 4L));
        }
        this.buffer = buffer.slice(address, length * 4L);
        this.length = length;
    }

    public int get(long index) {
        return this.buffer.getInt(index * 4L);
    }

    public void get(long index, int[] ints, int start, int length) {
        for (int i = 0; i < length; ++i) {
            ints[start + i] = this.buffer.getInt((index + (long)i) * 4L);
        }
    }

    public void get(long index, int[] ints) {
        this.get(index, ints, 0, ints.length);
    }

    public void get(long index, IntArray ints, long start, long length) {
        ints.set(start, this, index, length);
    }

    public void get(long index, IntArray ints) {
        this.get(index, ints, 0L, ints.length);
    }

    public void set(long index, int value) {
        this.buffer.putInt(index * 4L, value);
    }

    public void set(long index, int[] ints, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.putInt((index + (long)i) * 4L, ints[start + i]);
        }
    }

    public void set(long index, int[] ints) {
        this.set(index, ints, 0, ints.length);
    }

    public void set(long index, IntArray ints, long start, long length) {
        ints.buffer.getBytes(index * 4L, this.buffer, start * 4L, length * 4L);
    }

    public void set(long index, IntArray ints) {
        this.set(index, ints, 0L, ints.length);
    }

    public long length() {
        return this.length;
    }

    public IntArray slice(long start, long length) {
        return new IntArray(this.buffer, start * 4L, length);
    }
}

