/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.AbstractMemory;
import com.indeed.util.mmap.HeapDataAccess;
import com.indeed.util.mmap.Memory;
import com.indeed.util.mmap.NativeEndianHeapDataAccess;
import com.indeed.util.mmap.ReverseEndianHeapDataAccess;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeapMemory
extends AbstractMemory {
    private static final Logger log = LoggerFactory.getLogger(HeapMemory.class);
    private static final boolean debug = true;
    private final byte[] data;
    private final int offset;
    private final int length;
    private final HeapDataAccess dataAccess;
    private final ByteOrder endianness;

    public HeapMemory(int length, ByteOrder endianness) {
        this(new byte[length], endianness);
    }

    public HeapMemory(byte[] data, ByteOrder endianness) {
        this(data, 0, data.length, endianness);
    }

    public HeapMemory(byte[] data, int offset, int length, ByteOrder endianness) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.endianness = endianness;
        this.dataAccess = endianness == ByteOrder.nativeOrder() ? NativeEndianHeapDataAccess.getInstance() : ReverseEndianHeapDataAccess.getInstance();
    }

    private void checkBounds(long l, long length) {
        if (l < 0L || l > (long)this.length - length) {
            throw new IndexOutOfBoundsException(String.valueOf(l));
        }
    }

    private void checkArrayBounds(byte[] bytes, int start, int length) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte[] bytes cannot be null");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("start cannot be less than zero");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be less than zero");
        }
        if (start + length > bytes.length) {
            throw new IndexOutOfBoundsException("start plus length cannot be greater than length of byte[] bytes");
        }
        if (start + length < 0) {
            throw new IndexOutOfBoundsException("start plus length cannot be greater than Integer.MAX_VALUE");
        }
    }

    @Override
    public byte getByte(long l) {
        this.checkBounds(l, 1L);
        return this.data[(int)((long)this.offset + l)];
    }

    @Override
    public void putByte(long l, byte b) {
        this.checkBounds(l, 1L);
        this.data[(int)((long)this.offset + l)] = b;
    }

    @Override
    public short getShort(long l) {
        this.checkBounds(l, 2L);
        return this.dataAccess.getShort(this.data, (int)((long)this.offset + l));
    }

    @Override
    public void putShort(long l, short i) {
        this.checkBounds(l, 2L);
        this.dataAccess.putShort(this.data, (int)((long)this.offset + l), i);
    }

    @Override
    public char getChar(long l) {
        this.checkBounds(l, 2L);
        return this.dataAccess.getChar(this.data, (int)((long)this.offset + l));
    }

    @Override
    public void putChar(long l, char c) {
        this.checkBounds(l, 2L);
        this.dataAccess.putChar(this.data, (int)((long)this.offset + l), c);
    }

    @Override
    public int getInt(long l) {
        this.checkBounds(l, 4L);
        return this.dataAccess.getInt(this.data, (int)((long)this.offset + l));
    }

    @Override
    public void putInt(long l, int i) {
        this.checkBounds(l, 4L);
        this.dataAccess.putInt(this.data, (int)((long)this.offset + l), i);
    }

    @Override
    public long getLong(long l) {
        this.checkBounds(l, 8L);
        return this.dataAccess.getLong(this.data, (int)((long)this.offset + l));
    }

    @Override
    public void putLong(long l, long l1) {
        this.checkBounds(l, 8L);
        this.dataAccess.putLong(this.data, (int)((long)this.offset + l), l1);
    }

    @Override
    public float getFloat(long l) {
        this.checkBounds(l, 4L);
        return this.dataAccess.getFloat(this.data, (int)((long)this.offset + l));
    }

    @Override
    public void putFloat(long l, float v) {
        this.checkBounds(l, 4L);
        this.dataAccess.putFloat(this.data, (int)((long)this.offset + l), v);
    }

    @Override
    public double getDouble(long l) {
        this.checkBounds(l, 8L);
        return this.dataAccess.getDouble(this.data, (int)((long)this.offset + l));
    }

    @Override
    public void putDouble(long l, double v) {
        this.checkBounds(l, 8L);
        this.dataAccess.putDouble(this.data, (int)((long)this.offset + l), v);
    }

    @Override
    public void putBytes(long l, byte[] bytes) {
        this.putBytes(l, bytes, 0, bytes.length);
    }

    @Override
    public void putBytes(long l, byte[] bytes, int start, int length) {
        this.checkBounds(l, length);
        this.checkArrayBounds(bytes, start, length);
        System.arraycopy(bytes, start, this.data, (int)((long)this.offset + l), length);
    }

    @Override
    public void putBytes(long l, Memory source) {
        this.putBytes(l, source, 0L, source.length());
    }

    @Override
    public void putBytes(long l, Memory source, long start, long length) {
        this.checkBounds(l, length);
        source.getBytes(start, this.data, (int)((long)this.offset + l), (int)length);
    }

    @Override
    public void putBytes(long l, ByteBuffer source) {
        int length = source.remaining();
        this.checkBounds(l, length);
        source.get(this.data, (int)((long)this.offset + l), length);
    }

    @Override
    public void getBytes(long l, byte[] bytes) {
        this.getBytes(l, bytes, 0, bytes.length);
    }

    @Override
    public void getBytes(long l, byte[] bytes, int start, int length) {
        this.checkBounds(l, length);
        this.checkArrayBounds(bytes, start, length);
        System.arraycopy(this.data, (int)((long)this.offset + l), bytes, start, length);
    }

    @Override
    public void getBytes(long l, Memory dest) {
        this.getBytes(l, dest, 0L, dest.length());
    }

    @Override
    public void getBytes(long l, Memory dest, long start, long length) {
        this.checkBounds(l, length);
        dest.putBytes(start, this.data, (int)((long)this.offset + l), (int)length);
    }

    @Override
    public void getBytes(long l, ByteBuffer dest) {
        int length = dest.remaining();
        this.checkBounds(l, length);
        dest.put(this.data, (int)((long)this.offset + l), length);
    }

    @Override
    public Memory slice(long startAddress, long sliceLength) {
        if (startAddress < 0L) {
            throw new IllegalArgumentException("startAddress must be >= 0");
        }
        if (sliceLength < 0L) {
            throw new IllegalArgumentException("sliceLength must be >= 0");
        }
        if (startAddress + sliceLength > (long)this.length) {
            throw new IllegalArgumentException("startAddress+sliceLength must be <= length");
        }
        return new HeapMemory(this.data, (int)((long)this.offset + startAddress), (int)sliceLength, this.endianness);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ByteOrder getOrder() {
        return this.endianness;
    }
}

