/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryScatteringByteChannel
implements ScatteringByteChannel {
    private static final Logger log = LoggerFactory.getLogger(MemoryScatteringByteChannel.class);
    private boolean closed = false;
    private final Memory memory;
    private long position = 0L;

    public MemoryScatteringByteChannel(Memory memory) {
        this.memory = memory;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(offset));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(length));
        }
        if (offset + length > dsts.length) {
            throw new IndexOutOfBoundsException(String.valueOf(offset + length));
        }
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            int read = this.read(dsts[i]);
            if (read < 0) {
                if (total == 0L) {
                    return -1L;
                }
                return total;
            }
            total += (long)read;
        }
        return total;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.memory.length() - this.position <= 0L) {
            return -1;
        }
        int length = (int)Math.min((long)dst.remaining(), this.memory.length() - this.position);
        dst.limit(length);
        this.memory.getBytes(this.position, dst);
        this.position += (long)length;
        return length;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

