/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.indeed.util.mmap.DirectMemory;
import com.indeed.util.mmap.LoadIndeedMMap;
import com.indeed.util.mmap.NativeBuffer;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;

public final class Stat {
    private static final Logger log = Logger.getLogger(Stat.class);
    private static final Field fdField;
    private static final int S_IFMT = 61440;
    private static final int S_IFSOCK = 49152;
    private static final int S_IFLNK = 40960;
    private static final int S_IFREG = 32768;
    private static final int S_IFBLK = 24576;
    private static final int S_IFDIR = 16384;
    private static final int S_IFCHR = 8192;
    private static final int S_IFIFO = 4096;
    private static final int S_ISUID = 2048;
    private static final int S_ISGID = 1024;
    private static final int S_ISVTX = 512;
    private static final int S_IRWXU = 448;
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRWXG = 56;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IRWXO = 7;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;
    private static final ImmutableList<String> errstr;
    private final long device;
    private final long inode;
    private final int mode;
    private final long numLinks;
    private final int uid;
    private final int gid;
    private final long rdev;
    private final long size;
    private final long blockSize;
    private final long numBlocks;
    private final long aTime;
    private final long mTime;
    private final long cTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stat stat(String file) throws IOException {
        try (NativeBuffer nativeBuffer = new NativeBuffer(92L, ByteOrder.nativeOrder());){
            DirectMemory direct = nativeBuffer.memory();
            int err = Stat.stat(file, direct.getAddress());
            if (err != 0) {
                if (err == errstr.indexOf((Object)"ENOENT")) {
                    throw new FileNotFoundException("No such file or directory: " + file);
                }
                throw new IOException("stat on path " + file + " failed with error " + (err < 0 ? "unknown" : (String)errstr.get(err)));
            }
            Stat stat = new Stat(direct);
            return stat;
        }
    }

    public static Stat stat(File file) throws IOException {
        return Stat.stat(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stat lstat(String file) throws IOException {
        try (NativeBuffer nativeBuffer = new NativeBuffer(92L, ByteOrder.nativeOrder());){
            DirectMemory direct = nativeBuffer.memory();
            int err = Stat.lstat(file, direct.getAddress());
            if (err == errstr.indexOf((Object)"ENOENT")) {
                throw new FileNotFoundException("No such file or directory: " + file);
            }
            if (err != 0) {
                throw new IOException("stat on path " + file + " failed with error " + (err < 0 ? "unknown" : (String)errstr.get(err)));
            }
            Stat stat = new Stat(direct);
            return stat;
        }
    }

    public static Stat lstat(File file) throws IOException {
        return Stat.lstat(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stat fstat(FileDescriptor fd) throws IOException {
        try (NativeBuffer nativeBuffer = new NativeBuffer(92L, ByteOrder.nativeOrder());){
            DirectMemory direct = nativeBuffer.memory();
            try {
                int err = Stat.fstat(fdField.getInt(fd), direct.getAddress());
                if (err == errstr.indexOf((Object)"ENOENT")) {
                    throw new FileNotFoundException("No such file or directory");
                }
                if (err != 0) {
                    throw new IOException("fstat on file descriptor " + fd + " failed with error " + (err < 0 ? "unknown" : (String)errstr.get(err)));
                }
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
            Stat stat = new Stat(direct);
            return stat;
        }
    }

    private static native int stat(String var0, long var1);

    private static native int lstat(String var0, long var1);

    private static native int fstat(int var0, long var1);

    private Stat(DirectMemory direct) {
        this.device = direct.getLong(0L);
        this.inode = direct.getLong(8L);
        this.mode = direct.getInt(16L);
        this.numLinks = direct.getLong(20L);
        this.uid = direct.getInt(28L);
        this.gid = direct.getInt(32L);
        this.rdev = direct.getLong(36L);
        this.size = direct.getLong(44L);
        this.blockSize = direct.getLong(52L);
        this.numBlocks = direct.getLong(60L);
        this.aTime = direct.getLong(68L);
        this.mTime = direct.getLong(76L);
        this.cTime = direct.getLong(84L);
    }

    public long getDevice() {
        return this.device;
    }

    public long getInode() {
        return this.inode;
    }

    public int getMode() {
        return this.mode;
    }

    public long getNumLinks() {
        return this.numLinks;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public long getRdev() {
        return this.rdev;
    }

    public long getSize() {
        return this.size;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public long getNumBlocks() {
        return this.numBlocks;
    }

    public long getaTime() {
        return this.aTime;
    }

    public long getmTime() {
        return this.mTime;
    }

    public long getcTime() {
        return this.cTime;
    }

    private int getFileTypeBits() {
        return this.getMode() & 0xF000;
    }

    public boolean isRegularFile() {
        return this.getFileTypeBits() == 32768;
    }

    public boolean isDirectory() {
        return this.getFileTypeBits() == 16384;
    }

    public boolean isCharacterDevice() {
        return this.getFileTypeBits() == 8192;
    }

    public boolean isBlockDevice() {
        return this.getFileTypeBits() == 24576;
    }

    public boolean isFifo() {
        return this.getFileTypeBits() == 4096;
    }

    public boolean isSymlink() {
        return this.getFileTypeBits() == 40960;
    }

    public boolean isSock() {
        return this.getFileTypeBits() == 49152;
    }

    public boolean getSUID() {
        return (this.getMode() & 0x800) == 2048;
    }

    public boolean getSGID() {
        return (this.getMode() & 0x400) == 1024;
    }

    public boolean isSticky() {
        return (this.getMode() & 0x200) == 512;
    }

    public boolean isUserReadable() {
        return (this.getMode() & 0x100) == 256;
    }

    public boolean isUserWritable() {
        return (this.getMode() & 0x80) == 128;
    }

    public boolean isUserExecutable() {
        return (this.getMode() & 0x40) == 64;
    }

    public boolean isGroupReadable() {
        return (this.getMode() & 0x20) == 32;
    }

    public boolean isGroupWritable() {
        return (this.getMode() & 0x10) == 16;
    }

    public boolean isGroupExecutable() {
        return (this.getMode() & 8) == 8;
    }

    public boolean isOtherReadable() {
        return (this.getMode() & 4) == 4;
    }

    public boolean isOtherWritable() {
        return (this.getMode() & 2) == 2;
    }

    public boolean isOtherExecutable() {
        return (this.getMode() & 1) == 1;
    }

    public String toString() {
        return "Stat{device=" + this.device + ", inode=" + this.inode + ", mode=" + String.format("%x", this.mode) + ", numLinks=" + this.numLinks + ", uid=" + this.uid + ", gid=" + this.gid + ", rdev=" + this.rdev + ", size=" + this.size + ", blockSize=" + this.blockSize + ", numBlocks=" + this.numBlocks + ", aTime=" + this.aTime + ", mTime=" + this.mTime + ", cTime=" + this.cTime + '}';
    }

    static {
        errstr = ImmutableList.of((Object)"OK", (Object)"EACCES", (Object)"EBADF", (Object)"EFAULT", (Object)"ELOOP", (Object)"ENAMETOOLONG", (Object)"ENOENT", (Object)"ENOMEM", (Object)"ENOTDIR", (Object)"EOVERFLOW");
        try {
            fdField = FileDescriptor.class.getDeclaredField("fd");
            fdField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
        LoadIndeedMMap.loadLibrary();
    }
}

