/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import org.apache.log4j.Logger;

public final class ShortArray {
    private static final Logger log = Logger.getLogger(ShortArray.class);
    private static final long TYPE_SIZE = 2L;
    private final Memory buffer;
    private final long length;

    public ShortArray(Memory buffer, long address, long length) {
        if (address < 0L) {
            throw new IndexOutOfBoundsException("address must be >= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (address + length * 2L > buffer.length()) {
            throw new IndexOutOfBoundsException(String.format("address+length*%d must be <= buffer.length()", 2L));
        }
        this.buffer = buffer.slice(address, length * 2L);
        this.length = length;
    }

    public short get(long index) {
        return this.buffer.getShort(index * 2L);
    }

    public void get(long index, short[] shorts, int start, int length) {
        for (int i = 0; i < length; ++i) {
            shorts[start + i] = this.buffer.getShort((index + (long)i) * 2L);
        }
    }

    public void get(long index, short[] shorts) {
        this.get(index, shorts, 0, shorts.length);
    }

    public void get(long index, ShortArray shorts, long start, long length) {
        shorts.set(start, this, index, length);
    }

    public void get(long index, ShortArray shorts) {
        this.get(index, shorts, 0L, shorts.length);
    }

    public void set(long index, short value) {
        this.buffer.putShort(index * 2L, value);
    }

    public void set(long index, short[] shorts, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.putShort((index + (long)i) * 2L, shorts[start + i]);
        }
    }

    public void set(long index, short[] shorts) {
        this.set(index, shorts, 0, shorts.length);
    }

    public void set(long index, ShortArray shorts, long start, long length) {
        shorts.buffer.getBytes(index * 2L, this.buffer, start * 2L, length * 2L);
    }

    public void set(long index, ShortArray shorts) {
        this.set(index, shorts, 0L, shorts.length);
    }

    public long length() {
        return this.length;
    }

    public ShortArray slice(long start, long length) {
        return new ShortArray(this.buffer, start * 2L, length);
    }
}

