/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.google.common.annotations.VisibleForTesting;
import com.indeed.util.mmap.BufferResource;
import com.indeed.util.mmap.DirectMemory;
import com.indeed.util.mmap.LoadIndeedMMap;
import com.indeed.util.mmap.NativeMemoryUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public final class MMapBuffer
implements BufferResource {
    private static final Logger log = Logger.getLogger(MMapBuffer.class);
    private static final Field FD_FIELD;
    public static final int PAGE_SIZE = 4096;
    private static final int READ_ONLY = 0;
    static final int READ_WRITE = 1;
    static final long MAP_FAILED = -1L;
    static final int MAP_SHARED = 1;
    static final int MAP_PRIVATE = 2;
    static final int MAP_ANONYMOUS = 4;
    private final long address;
    private final DirectMemory memory;

    public MMapBuffer(File file, FileChannel.MapMode mapMode, ByteOrder order) throws IOException {
        this(file, 0L, file.length(), mapMode, order);
    }

    public MMapBuffer(File file, long offset, long length, FileChannel.MapMode mapMode, ByteOrder order) throws IOException {
        if (!file.exists() && mapMode == FileChannel.MapMode.READ_ONLY) {
            throw new FileNotFoundException(file + " does not exist");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("error mapping [" + file + "]: offset must be >= 0");
        }
        if (length <= 0L) {
            if (length < 0L) {
                throw new IllegalArgumentException("error mapping [" + file + "]: length must be >= 0");
            }
            this.address = 0L;
            this.memory = new DirectMemory(0L, 0L, order);
        } else {
            int fd;
            int prot;
            String openMode;
            if (mapMode == FileChannel.MapMode.READ_ONLY) {
                openMode = "r";
                prot = 0;
            } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
                openMode = "rw";
                prot = 1;
            } else {
                throw new IllegalArgumentException("only MapMode.READ_ONLY and MapMode.READ_WRITE are supported");
            }
            RandomAccessFile raf = new RandomAccessFile(file, openMode);
            if (raf.length() < offset + length) {
                if (mapMode == FileChannel.MapMode.READ_WRITE) {
                    raf.setLength(offset + length);
                    raf.close();
                    raf = new RandomAccessFile(file, openMode);
                } else {
                    throw new IllegalArgumentException("cannot open file [" + file + "] in read only mode with offset+length > file.length()");
                }
            }
            try {
                fd = FD_FIELD.getInt(raf.getFD());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.address = MMapBuffer.mmap(length, prot, 1, fd, offset);
            try {
                raf.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.address == -1L) {
                int errno = MMapBuffer.errno();
                throw new IOException("mmap(" + file.getAbsolutePath() + ", " + offset + ", " + length + ", " + mapMode + ") failed [Errno " + errno + "]");
            }
            this.memory = new DirectMemory(this.address, length, order);
        }
    }

    static native long mmap(long var0, int var2, int var3, int var4, long var5);

    static native int munmap(long var0, long var2);

    static native long mremap(long var0, long var2, long var4);

    private static native int msync(long var0, long var2);

    private static native int madvise(long var0, long var2);

    static native int errno();

    public void advise(long position, long length) throws IOException {
        long ap = this.address + position;
        long a = ap / 4096L * 4096L;
        long l = Math.min(length + (ap - a), this.address + this.memory.length() - ap);
        int err = MMapBuffer.madvise(a, l);
        if (err != 0) {
            throw new IOException("madvise failed with error code: " + err);
        }
    }

    public void sync(long position, long length) throws IOException {
        long ap = this.address + position;
        long a = ap / 4096L * 4096L;
        long l = Math.min(length + (ap - a), this.address + this.memory.length() - ap);
        int err = MMapBuffer.msync(a, l);
        if (err != 0) {
            throw new IOException("msync failed with error code: " + err);
        }
    }

    public void mlock(long position, long length) {
        if (position < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (position + length > this.memory.length()) {
            throw new IndexOutOfBoundsException();
        }
        NativeMemoryUtils.mlock(this.address + position, length);
    }

    public void munlock(long position, long length) {
        if (position < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (position + length > this.memory.length()) {
            throw new IndexOutOfBoundsException();
        }
        NativeMemoryUtils.munlock(this.address + position, length);
    }

    public void mincore(long position, long length, DirectMemory direct) {
        if (position + length > this.memory().length()) {
            throw new IndexOutOfBoundsException();
        }
        long ap = this.address + position;
        long a = ap / 4096L * 4096L;
        long l = length + (ap - a);
        if ((l + 4096L - 1L) / 4096L > direct.length()) {
            throw new IndexOutOfBoundsException();
        }
        NativeMemoryUtils.mincore(a, l, direct);
    }

    @VisibleForTesting
    int getErrno() {
        return MMapBuffer.errno();
    }

    @Override
    public void close() throws IOException {
        if (this.address != 0L && MMapBuffer.munmap(this.address, this.memory.length()) != 0) {
            throw new IOException("munmap failed [Errno " + MMapBuffer.errno() + "]");
        }
    }

    @Override
    public DirectMemory memory() {
        return this.memory;
    }

    static {
        LoadIndeedMMap.loadLibrary();
        try {
            FD_FIELD = FileDescriptor.class.getDeclaredField("fd");
            FD_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

