/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import com.google.common.base.Throwables;
import com.indeed.util.io.Positioned;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ByteBufferDataOutputStream
extends OutputStream
implements DataOutput,
Positioned {
    private ByteBuffer buffer;
    private final boolean direct;
    private final DataOutputStream dataOutputStream = new DataOutputStream(this);

    public ByteBufferDataOutputStream() {
        this(128);
    }

    public ByteBufferDataOutputStream(int initialSize) {
        this(initialSize, false);
    }

    public ByteBufferDataOutputStream(int initialSize, boolean direct) {
        this.direct = direct;
        this.buffer = direct ? ByteBuffer.allocateDirect(initialSize) : ByteBuffer.allocate(initialSize);
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(1);
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(len);
        this.buffer.put(b, off, len);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void writeBoolean(boolean v) {
        this.ensureCapacity(1);
        this.buffer.put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) {
        this.ensureCapacity(1);
        this.buffer.put((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.ensureCapacity(2);
        this.buffer.putShort((short)v);
    }

    @Override
    public void writeChar(int v) {
        this.ensureCapacity(2);
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeInt(int v) {
        this.ensureCapacity(4);
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.ensureCapacity(8);
        this.buffer.putLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.ensureCapacity(4);
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        this.ensureCapacity(8);
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        try {
            this.dataOutputStream.writeBytes(s);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void writeChars(String s) {
        try {
            this.dataOutputStream.writeChars(s);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void writeUTF(String s) {
        try {
            this.dataOutputStream.writeUTF(s);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void ensureCapacity(int size) {
        if (this.buffer.remaining() < size) {
            int newSize = Math.max(this.buffer.capacity() * 2, this.buffer.capacity() + size);
            ByteBuffer newBuffer = this.direct ? ByteBuffer.allocateDirect(newSize) : ByteBuffer.allocate(newSize);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public ByteBuffer getBuffer() {
        ByteBuffer duplicate = this.buffer.duplicate();
        duplicate.flip();
        return duplicate.slice().asReadOnlyBuffer();
    }

    public ByteBuffer getBufferUnsafe() {
        return this.buffer;
    }

    @Override
    public long position() throws IOException {
        return this.buffer.position();
    }

    public void clear() {
        this.buffer.clear();
    }
}

