/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class Directories {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnegative
    public static int count(@Nonnull Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            int n = Iterables.size(stream);
            return n;
        }
        catch (DirectoryIteratorException ex) {
            throw ex.getCause();
        }
    }

    @Nonnull
    public static List<Path> list(@Nonnull Path dir) throws IOException {
        ArrayList<Path> contents = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                contents.add(entry);
            }
        }
        catch (DirectoryIteratorException ex) {
            throw ex.getCause();
        }
        return contents;
    }

    private Directories() {
    }
}

