/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import java.io.OutputStream;
import java.util.Arrays;
import org.apache.log4j.Logger;

public final class UnsafeByteArrayOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger(UnsafeByteArrayOutputStream.class);
    private byte[] buf;
    private int count = 0;

    public UnsafeByteArrayOutputStream() {
        this(32);
    }

    public UnsafeByteArrayOutputStream(int initialCapacity) {
        this.buf = new byte[initialCapacity];
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public int size() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }
}

