/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Pair<A, B>
implements Serializable {
    private static final long serialVersionUID = -7675178028057823346L;
    private final A a;
    private final B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A getFirst() {
        return this.a;
    }

    public B getSecond() {
        return this.b;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            Pair p = (Pair)obj;
            A a = p.getFirst();
            B b = p.getSecond();
            return (a == null ? this.a == null : a.equals(this.a)) && (b == null ? this.b == null : b.equals(this.b));
        }
        return false;
    }

    public int hashCode() {
        int result = this.a != null ? this.a.hashCode() : 0;
        result = 31 * result + (this.b != null ? this.b.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this.a + ", " + this.b + ")";
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    @Nonnull
    @Deprecated
    public static <T1, T2> Function<Pair<? extends T1, ? extends T2>, ? extends T1> fst(@Nonnull Class<T1> clazz) {
        return new First();
    }

    @Nonnull
    public static <T> Function<Pair<? extends T, ?>, ? extends T> fst() {
        return new Function<Pair<? extends T, ?>, T>(){

            @Nullable
            public T apply(@Nullable Pair<? extends T, ?> input) {
                return input == null ? null : (Object)input.getFirst();
            }
        };
    }

    @Nonnull
    @Deprecated
    public static <T1, T2> Function<Pair<? extends T1, ? extends T2>, ? extends T2> snd(@Nonnull Class<T2> clazz) {
        return new Second();
    }

    @Nonnull
    public static <T> Function<Pair<?, ? extends T>, ? extends T> snd() {
        return new Function<Pair<?, ? extends T>, T>(){

            @Nullable
            public T apply(@Nullable Pair<?, ? extends T> input) {
                return input == null ? null : (Object)input.getSecond();
            }
        };
    }

    private static final class Second<T1, T2>
    implements Function<Pair<? extends T1, ? extends T2>, T2> {
        private Second() {
        }

        @Nullable
        public T2 apply(@Nullable Pair<? extends T1, ? extends T2> input) {
            return input == null ? null : (T2)input.getSecond();
        }
    }

    private static final class First<T1, T2>
    implements Function<Pair<? extends T1, ? extends T2>, T1> {
        private First() {
        }

        @Nullable
        public T1 apply(@Nullable Pair<? extends T1, ? extends T2> input) {
            return input == null ? null : (T1)input.getFirst();
        }
    }

    public static class HalfPairComparator
    implements Comparator<Pair> {
        @Override
        public int compare(Pair o1, Pair o2) {
            return ((Comparable)o1.a).compareTo(o2.a);
        }
    }

    public static class FullPairComparator
    implements Comparator<Pair> {
        @Override
        public int compare(Pair o1, Pair o2) {
            int ret = ((Comparable)o1.a).compareTo(o2.a);
            if (ret == 0) {
                return ((Comparable)o1.b).compareTo(o2.b);
            }
            return ret;
        }
    }
}

