/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.google.common.base.Function;

public interface Either<A extends Throwable, B> {
    public <Z> Z match(Matcher<A, B, Z> var1) throws A;

    public <C> Either<A, C> map(Function<B, C> var1);

    public <C> Either<A, C> flatMap(Function<B, Either<A, C>> var1);

    public B get() throws A;

    public static final class Right<A extends Throwable, B>
    implements Either<A, B> {
        private final B b;

        public static <A extends Throwable, B> Either<A, B> of(B b) {
            return new Right<A, B>(b);
        }

        private Right(B b) {
            this.b = b;
        }

        @Override
        public <Z> Z match(Matcher<A, B, Z> matcher) {
            return matcher.right(this.b);
        }

        @Override
        public <C> Either<A, C> map(Function<B, C> f) {
            return Right.of(f.apply(this.b));
        }

        @Override
        public <C> Either<A, C> flatMap(Function<B, Either<A, C>> f) {
            return (Either)f.apply(this.b);
        }

        @Override
        public B get() throws A {
            return this.b;
        }
    }

    public static final class Left<A extends Throwable, B>
    implements Either<A, B> {
        private final A a;

        public static <A extends Throwable, B> Either<A, B> of(A a) {
            return new Left<A, B>(a);
        }

        private Left(A a) {
            this.a = a;
        }

        @Override
        public <Z> Z match(Matcher<A, B, Z> matcher) throws A {
            return matcher.left(this.a);
        }

        @Override
        public <C> Either<A, C> map(Function<B, C> f) {
            return this;
        }

        @Override
        public <C> Either<A, C> flatMap(Function<B, Either<A, C>> f) {
            return this;
        }

        @Override
        public B get() throws A {
            throw this.a;
        }
    }

    public static abstract class Matcher<A extends Throwable, B, Z> {
        protected Z left(A a) throws A {
            throw a;
        }

        protected Z right(B b) {
            throw new UnsupportedOperationException();
        }
    }
}

