/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.google.common.annotations.VisibleForTesting;

public class DataLoadTimer {
    private Long lastSuccessLoad = null;
    private Long lastFailLoad = null;
    private Long lastLoadCheck = null;
    @VisibleForTesting
    protected boolean lastLoadWasSuccessful = false;

    public void updateLastLoadCheck() {
        this.lastLoadCheck = System.currentTimeMillis();
    }

    protected void updateLastSuccessLoadTime() {
        this.lastSuccessLoad = System.currentTimeMillis();
        this.lastLoadWasSuccessful = true;
    }

    public void loadComplete() {
        this.lastSuccessLoad = System.currentTimeMillis();
        this.lastLoadWasSuccessful = true;
    }

    public void loadFailed() {
        this.lastFailLoad = System.currentTimeMillis();
        this.lastLoadWasSuccessful = false;
    }

    public Integer getSecondsSinceLastLoad() {
        if (this.lastSuccessLoad == null) {
            return null;
        }
        return (int)(System.currentTimeMillis() - this.lastSuccessLoad) / 1000;
    }

    public Integer getSecondsSinceLastFailedLoad() {
        if (this.lastFailLoad == null) {
            return null;
        }
        return (int)(System.currentTimeMillis() - this.lastFailLoad) / 1000;
    }

    public Integer getSecondsSinceLastLoadCheck() {
        if (this.lastLoadCheck == null) {
            return null;
        }
        return (int)(System.currentTimeMillis() - this.lastLoadCheck) / 1000;
    }

    public boolean wasLastLoadErroring() {
        return !this.isLoadedDataSuccessfullyRecently();
    }

    public boolean isLoadedDataSuccessfullyRecently() {
        Integer timeSinceLastError = this.getSecondsSinceLastFailedLoad();
        Integer timeSinceLastSuccess = this.getSecondsSinceLastLoad();
        if (timeSinceLastSuccess == null) {
            return false;
        }
        if (timeSinceLastError == null) {
            return true;
        }
        return this.lastLoadWasSuccessful;
    }
}

