/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.compress;

import com.indeed.util.compress.BlockCompressorStream;
import com.indeed.util.compress.BlockDecompressorStream;
import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.compress.CompressionInputStream;
import com.indeed.util.compress.CompressionOutputStream;
import com.indeed.util.compress.Compressor;
import com.indeed.util.compress.Decompressor;
import com.indeed.util.compress.snappy.SnappyCompressor;
import com.indeed.util.compress.snappy.SnappyDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SnappyCodec
implements CompressionCodec {
    public static void checkNativeCodeLoaded() {
        if (!SnappyCompressor.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available: SnappyCompressor has not been loaded.");
        }
        if (!SnappyDecompressor.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available: SnappyDecompressor has not been loaded.");
        }
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        SnappyCodec.checkNativeCodeLoaded();
        int bufferSize = 262144;
        int compressionOverhead = 43722;
        return new BlockCompressorStream(out, compressor, 262144, 43722);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        SnappyCodec.checkNativeCodeLoaded();
        return SnappyCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        SnappyCodec.checkNativeCodeLoaded();
        int bufferSize = 262144;
        return new SnappyCompressor(262144);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        SnappyCodec.checkNativeCodeLoaded();
        return new BlockDecompressorStream(in, decompressor, 262144);
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        SnappyCodec.checkNativeCodeLoaded();
        return SnappyDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        SnappyCodec.checkNativeCodeLoaded();
        int bufferSize = 262144;
        return new SnappyDecompressor(262144);
    }

    @Override
    public String getDefaultExtension() {
        return ".snappy";
    }
}

