/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.compress;

import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.compress.CompressionInputStream;
import com.indeed.util.compress.CompressionOutputStream;
import com.indeed.util.compress.Compressor;
import com.indeed.util.compress.CompressorStream;
import com.indeed.util.compress.Decompressor;
import com.indeed.util.compress.DecompressorStream;
import com.indeed.util.compress.zlib.ZlibCompressor;
import com.indeed.util.compress.zlib.ZlibDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCodec
implements CompressionCodec {
    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new CompressorStream(out, this.createCompressor(), 4096);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return compressor != null ? new CompressorStream(out, compressor, 4096) : this.createOutputStream(out);
    }

    @Override
    public Compressor createCompressor() {
        return new GzipZlibCompressor();
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return GzipZlibCompressor.class;
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, null);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (decompressor == null) {
            decompressor = this.createDecompressor();
        }
        return new DecompressorStream(in, decompressor, 4096);
    }

    @Override
    public Decompressor createDecompressor() {
        return new GzipZlibDecompressor();
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return GzipZlibDecompressor.class;
    }

    @Override
    public String getDefaultExtension() {
        return ".gz";
    }

    static final class GzipZlibDecompressor
    extends ZlibDecompressor {
        public GzipZlibDecompressor() {
            super(ZlibDecompressor.CompressionHeader.AUTODETECT_GZIP_ZLIB, 65536);
        }
    }

    static final class GzipZlibCompressor
    extends ZlibCompressor {
        public GzipZlibCompressor() {
            super(ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION, ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY, ZlibCompressor.CompressionHeader.GZIP_FORMAT, 65536);
        }
    }

    protected static class GzipOutputStream
    extends CompressorStream {
        public GzipOutputStream(OutputStream out) throws IOException {
            super(new ResetableGZIPOutputStream(out));
        }

        protected GzipOutputStream(CompressorStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        @Override
        public void finish() throws IOException {
            ((ResetableGZIPOutputStream)this.out).finish();
        }

        @Override
        public void resetState() throws IOException {
            ((ResetableGZIPOutputStream)this.out).resetState();
        }

        private static class ResetableGZIPOutputStream
        extends GZIPOutputStream {
            public ResetableGZIPOutputStream(OutputStream out) throws IOException {
                super(out);
            }

            public void resetState() throws IOException {
                this.def.reset();
            }
        }
    }
}

