/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestType;
import com.indeed.proctor.consumer.ProctorConsumerUtils;
import com.indeed.proctor.consumer.ProctorContextDescriptor;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractGroupsManager
implements ProctorContextDescriptor {
    private final Supplier<Proctor> proctorSource;

    protected AbstractGroupsManager(Supplier<Proctor> proctorSource) {
        this.proctorSource = proctorSource;
    }

    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(TestType testType, String identifier, Map<String, Object> context) {
        Map<String, Integer> forcedGroups = Collections.emptyMap();
        Identifiers identifiers = new Identifiers(testType, identifier);
        return this.determineBucketsInternal(identifiers, context, forcedGroups);
    }

    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(Identifiers identifiers, Map<String, Object> context) {
        return this.determineBucketsInternal(identifiers, context, Collections.emptyMap());
    }

    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(Identifiers identifiers, Map<String, Object> context, Map<String, Integer> forcedGroups) {
        Proctor proctor = (Proctor)this.proctorSource.get();
        if (proctor == null) {
            Map<String, TestBucket> buckets = this.getDefaultBucketValues();
            return new ProctorResult("", buckets, Collections.emptyMap(), Collections.emptyMap());
        }
        return proctor.determineTestGroups(identifiers, context, forcedGroups);
    }

    protected abstract Map<String, TestBucket> getDefaultBucketValues();

    protected ProctorResult determineBucketsInternal(HttpServletRequest request, HttpServletResponse response, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups) {
        Map<String, Integer> forcedGroups;
        if (allowForcedGroups) {
            forcedGroups = ProctorConsumerUtils.parseForcedGroups(request);
            ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(request.getContextPath(), forcedGroups).ifPresent(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
        } else {
            forcedGroups = Collections.emptyMap();
        }
        return this.determineBucketsInternal(identifiers, context, forcedGroups);
    }
}

