/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Strings;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.Bucket;
import com.indeed.proctor.consumer.Test;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public abstract class AbstractGroups {
    private static final Logger LOGGER = Logger.getLogger(AbstractGroups.class);
    private final ProctorResult proctorResult;
    protected static final char GROUPS_SEPARATOR = ',';
    protected static final char ALLOCATION_GROUP_SEPARATOR = ':';
    protected static final char TESTNAME_BUCKET_CONNECTOR = '-';

    protected AbstractGroups(ProctorResult proctorResult) {
        this.proctorResult = proctorResult;
    }

    protected int overrideDeterminedBucketValue(String testName, @Nonnull TestBucket determinedBucket) {
        return determinedBucket.getValue();
    }

    @Deprecated
    protected boolean isBucketActive(String testName, int value) {
        return this.getActiveBucket(testName).filter(testBucket -> value == testBucket.getValue()).isPresent();
    }

    protected boolean isBucketActive(String testName, int value, int defaultValue) {
        return value == this.getValue(testName, defaultValue);
    }

    protected int getValue(String testName, int defaultValue) {
        return this.getActiveBucket(testName).map(TestBucket::getValue).orElse(defaultValue);
    }

    protected final Optional<TestBucket> getActiveBucket(String testName) {
        TestBucket bucket = (TestBucket)this.proctorResult.getBuckets().get(testName);
        if (bucket == null) {
            return Optional.empty();
        }
        int overrideBucketValue = this.overrideDeterminedBucketValue(testName, bucket);
        if (overrideBucketValue != bucket.getValue()) {
            Optional<TestBucket> overrideBucketOpt = Optional.ofNullable(this.proctorResult.getTestDefinitions().get(testName)).map(ConsumableTestDefinition::getBuckets).orElse(Collections.emptyList()).stream().filter(b -> b.getValue() == overrideBucketValue).findFirst();
            if (overrideBucketOpt.isPresent()) {
                return overrideBucketOpt;
            }
            LOGGER.warn((Object)("Overriding bucket value " + overrideBucketValue + " for test '" + testName + "' does not match any bucket in test definition, using determined bucket value " + bucket.getValue()));
        }
        return Optional.of(bucket);
    }

    @Deprecated
    public final Map<String, String> getTestVersions() {
        return this.proctorResult.getTestVersions();
    }

    @Deprecated
    public final Map<String, String> getTestVersions(Set<String> tests) {
        LinkedHashMap<String, String> selectedTestVersions = new LinkedHashMap<String, String>();
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        for (String testName : tests) {
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
            if (testDefinition == null) continue;
            selectedTestVersions.put(testName, testDefinition.getVersion());
        }
        return selectedTestVersions;
    }

    @Deprecated
    @Nonnull
    protected Payload getPayload(String testName) {
        return Optional.ofNullable(this.getPayloadElseNull(testName)).orElse(Payload.EMPTY_PAYLOAD);
    }

    @Nonnull
    protected Payload getPayload(String testName, @Nonnull Bucket<?> fallbackBucket) {
        return Optional.ofNullable(this.getPayloadElseNull(testName)).orElseGet(() -> Optional.ofNullable(this.getTestBucketForBucket(testName, fallbackBucket)).map(TestBucket::getPayload).orElse(Payload.EMPTY_PAYLOAD));
    }

    @CheckForNull
    private Payload getPayloadElseNull(String testName) {
        return this.getActiveBucket(testName).map(TestBucket::getPayload).orElse(null);
    }

    @CheckForNull
    protected final TestBucket getTestBucketForBucket(String testName, Bucket<?> targetBucket) {
        return Optional.ofNullable(this.proctorResult.getTestDefinitions()).map(testDefinitions -> (ConsumableTestDefinition)testDefinitions.get(testName)).map(ConsumableTestDefinition::getBuckets).map(buckets -> buckets.stream().filter(testBucket -> targetBucket.getValue() == testBucket.getValue()).findFirst().orElse(null)).orElse(null);
    }

    public String toLongString() {
        if (this.isEmpty()) {
            return "";
        }
        Map buckets = this.proctorResult.getBuckets();
        StringBuilder sb = new StringBuilder(buckets.size() * 10);
        for (String testName : buckets.keySet()) {
            sb.append(testName).append('-').append(this.getActiveBucket(testName).map(TestBucket::getName).orElse("unknown")).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    @Deprecated
    public String toString() {
        return this.toLoggingString();
    }

    public String toLoggingString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.proctorResult.getBuckets().size() * 10);
        this.appendTestGroups(sb);
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Deprecated
    public final StringBuilder buildTestGroupString() {
        StringBuilder sb = new StringBuilder(this.proctorResult.getBuckets().size() * 10);
        this.appendTestGroups(sb);
        return sb;
    }

    protected boolean isEmpty() {
        return this.proctorResult.getBuckets().isEmpty();
    }

    public final void appendTestGroups(StringBuilder sb) {
        this.appendTestGroups(sb, ',');
    }

    public void appendTestGroups(StringBuilder sb, char separator) {
        List<String> testNames = this.getLoggingTestNames();
        this.appendTestGroupsWithoutAllocations(sb, separator, testNames);
        this.appendTestGroupsWithAllocations(sb, separator, testNames);
    }

    protected final List<String> getLoggingTestNames() {
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        Map buckets = this.proctorResult.getBuckets();
        return buckets.keySet().stream().filter(testBucket -> {
            ConsumableTestDefinition consumableTestDefinition = (ConsumableTestDefinition)testDefinitions.get(testBucket);
            return consumableTestDefinition == null || !consumableTestDefinition.getSilent();
        }).filter(testName -> this.getValue((String)testName, -1) >= 0).collect(Collectors.toList());
    }

    protected final void appendTestGroupsWithoutAllocations(StringBuilder sb, char separator, List<String> testNames) {
        for (String testName : testNames) {
            this.getActiveBucket(testName).ifPresent(testBucket -> sb.append(testName).append(testBucket.getValue()).append(separator));
        }
    }

    protected final void appendTestGroupsWithAllocations(StringBuilder sb, char separator, List<String> testNames) {
        for (String testName : testNames) {
            this.getActiveBucket(testName).ifPresent(testBucket -> {
                Allocation allocation = (Allocation)this.proctorResult.getAllocations().get(testName);
                if (allocation != null && !Strings.isNullOrEmpty((String)allocation.getId())) {
                    sb.append(allocation.getId()).append(':').append(testName).append(testBucket.getValue()).append(separator);
                }
            });
        }
    }

    public final Map<String, Integer> getJavaScriptConfig() {
        return this.proctorResult.getBuckets().keySet().stream().map(testName -> new AbstractMap.SimpleEntry<String, Integer>((String)testName, this.getValue((String)testName, -1))).filter(e -> (Integer)e.getValue() >= 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public final <E extends Test> List<List<Object>> getJavaScriptConfig(E[] tests) {
        return Arrays.stream(tests).map(test -> Arrays.asList(this.getValue(test.getName(), test.getFallbackValue()), this.getPayload(test.getName()).fetchAValue())).collect(Collectors.toList());
    }

    public ProctorResult getProctorResult() {
        return this.proctorResult;
    }
}

