/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.Bucket;
import com.indeed.proctor.consumer.Test;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractGroups {
    private final ProctorResult proctorResult;
    private final LinkedHashMap<String, TestBucket> buckets;
    protected static final char ALLOCATION_GROUP_SEPARATOR = ':';

    protected AbstractGroups(ProctorResult proctorResult) {
        this.proctorResult = proctorResult;
        this.buckets = Maps.newLinkedHashMap();
        for (Map.Entry entry : proctorResult.getBuckets().entrySet()) {
            TestBucket testBucket = (TestBucket)entry.getValue();
            this.buckets.put((String)entry.getKey(), testBucket);
        }
    }

    public Map<String, String> getTestVersions() {
        return this.proctorResult.getTestVersions();
    }

    protected boolean isBucketActive(String testName, int value) {
        TestBucket testBucket = this.buckets.get(testName);
        return testBucket != null && value == testBucket.getValue();
    }

    protected boolean isBucketActive(String testName, int value, int defaultValue) {
        TestBucket testBucket = this.buckets.get(testName);
        if (null == testBucket) {
            return value == defaultValue;
        }
        return value == testBucket.getValue();
    }

    protected int getValue(String testName, int defaultValue) {
        TestBucket testBucket = this.buckets.get(testName);
        if (testBucket == null) {
            return defaultValue;
        }
        return testBucket.getValue();
    }

    public Map<String, String> getTestVersions(Set<String> tests) {
        LinkedHashMap selectedTestVersions = Maps.newLinkedHashMap();
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        for (String testName : tests) {
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
            if (testDefinition == null) continue;
            selectedTestVersions.put(testName, testDefinition.getVersion());
        }
        return selectedTestVersions;
    }

    @Nonnull
    protected Payload getPayload(String testName) {
        Payload payload;
        TestBucket testBucket = this.buckets.get(testName);
        if (testBucket != null && null != (payload = testBucket.getPayload())) {
            return payload;
        }
        return Payload.EMPTY_PAYLOAD;
    }

    @Nonnull
    protected Payload getPayload(String testName, @Nonnull Bucket<?> fallbackBucket) {
        TestBucket fallbackTestBucket;
        TestBucket testBucket = this.buckets.get(testName);
        Object payload = testBucket != null ? testBucket.getPayload() : (null != (fallbackTestBucket = this.getTestBucketForBucket(testName, fallbackBucket)) ? fallbackTestBucket.getPayload() : null);
        return payload != null ? payload : Payload.EMPTY_PAYLOAD;
    }

    @Nullable
    protected TestBucket getTestBucketForBucket(String testName, Bucket<?> targetBucket) {
        List buckets;
        ConsumableTestDefinition testDefinition;
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        if (testDefinitions != null && (testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName)) != null && (buckets = testDefinition.getBuckets()) != null) {
            for (TestBucket testBucket : buckets) {
                if (targetBucket.getValue() != testBucket.getValue()) continue;
                return testBucket;
            }
        }
        return null;
    }

    public String toLongString() {
        if (this.proctorResult.getBuckets().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            sb.append(testName).append('-').append(testBucket.getName()).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = this.buildTestGroupString();
        if (sb.length() == 0) {
            return "";
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public StringBuilder buildTestGroupString() {
        StringBuilder sb = new StringBuilder();
        this.appendTestGroups(sb);
        return sb;
    }

    public void appendTestGroups(StringBuilder sb) {
        this.appendTestGroups(sb, ',');
    }

    protected boolean isEmpty() {
        return this.proctorResult.getBuckets().isEmpty();
    }

    public void appendTestGroups(StringBuilder sb, char separator) {
        List<String> testNames = this.getLoggingTestNames();
        this.appendTestGroupsWithoutAllocations(sb, separator, testNames);
        this.appendTestGroupsWithAllocations(sb, separator, testNames);
    }

    protected final List<String> getLoggingTestNames() {
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
            if (testDefinition != null && testDefinition.getSilent() || testBucket.getValue() < 0) continue;
            builder.add((Object)testName);
        }
        return builder.build();
    }

    protected final void appendTestGroupsWithoutAllocations(StringBuilder sb, char separator, List<String> testNames) {
        for (String testName : testNames) {
            TestBucket testBucket = (TestBucket)this.proctorResult.getBuckets().get(testName);
            if (testBucket == null) continue;
            sb.append(testName).append(testBucket.getValue()).append(separator);
        }
    }

    protected final void appendTestGroupsWithAllocations(StringBuilder sb, char separator, List<String> testNames) {
        for (String testName : testNames) {
            TestBucket testBucket = (TestBucket)this.proctorResult.getBuckets().get(testName);
            Allocation allocation = (Allocation)this.proctorResult.getAllocations().get(testName);
            if (testBucket == null || allocation == null || Strings.isNullOrEmpty((String)allocation.getId())) continue;
            sb.append(allocation.getId()).append(':').append(testName).append(testBucket.getValue()).append(separator);
        }
    }

    public Map<String, Integer> getJavaScriptConfig() {
        HashMap groups = Maps.newHashMapWithExpectedSize((int)this.proctorResult.getBuckets().size());
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            if (testBucket.getValue() < 0) continue;
            groups.put(testName, testBucket.getValue());
        }
        return groups;
    }

    public <E extends Test> List<List<Object>> getJavaScriptConfig(E[] tests) {
        Map buckets = this.getProctorResult().getBuckets();
        ArrayList<List<Object>> groups = new ArrayList<List<Object>>(tests.length);
        for (E test : tests) {
            Object payloadValue;
            String testName = test.getName();
            Integer bucketValue = this.getValue(testName, test.getFallbackValue());
            TestBucket testBucket = (TestBucket)buckets.get(testName);
            if (testBucket != null && testBucket.getPayload() != null) {
                Payload payload = testBucket.getPayload();
                payloadValue = payload.fetchAValue();
            } else {
                payloadValue = null;
            }
            ArrayList<Object> definition = new ArrayList<Object>();
            definition.add(bucketValue);
            definition.add(payloadValue);
            groups.add(definition);
        }
        return groups;
    }

    public ProctorResult getProctorResult() {
        return this.proctorResult;
    }
}

